<?php

namespace App\Console\Commands;

use App\Models\Post;
use Carbon\Carbon;
use Illuminate\Console\Command;
use App\Http\Controllers\User\TenderController;
use Illuminate\Support\Facades\Log;

class CheckTendersEveryMinute extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tender:everyminute';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check all available tender status every minute';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $activePosts = Post::where([['tender_status', '=',  1], ['end_time', '!=', NULL]])->get();
        $now = Carbon::now('Europe/Istanbul');
        foreach($activePosts as $activePost){
            $endTimeStr = $activePost->end_time;
            $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
            if($now->gt($endTime)){
                Log::channel('İlan')->info('İHALE SONUÇLANDI~'.$activePost->tender_code.' ilan kodlu '.$activePost->title.' başlıklı ihale başarıyla sonlanmıştır.');

                $activePost->tender_status = 2;
                TenderController::tenderWinnerMail($activePost);
                TenderController::tenderLoserMail($activePost);

                $activePost->save(); 
            }
        }
        $this->info('Active tenders has been checked successfully.');
    }
}