<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreBankRequest as StoreBank;
use App\Models\Bank;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class BankController extends Controller
{

    public function __construct()
    {
        $this->middleware('admin');
    }

    public function index()
    {
        $banks = Bank::all();
        // dd($banks);
        return view('admin.banks.index', compact('banks'));
    }


    public function create()
    {
        return view('admin.banks.create');
    }


    public function store(StoreBank $request)
    {


        //$bank = Bank::create($request->all()['property']);
        $bank = Bank::create($request->validated());
        
        Log::channel('Yönetici-Banka-Operasyon')->info('Y-BANKA KAYIT~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.'~'.$request->all()['name'].' isimli banka bilgisi oluşturuldu.');

        $request->session()->flash('status', 'Yeni banka başarılı bir şekilde oluşturuldu.');
        return redirect()->route('admin.banks.index');
    }

    
    public function show($id)
    {
        return redirect()->route('admin.banks.index');
    }


    public function edit($id)
    {
        $bank = Bank::findOrfail($id);

        $bankHasActivePosts = false;

        if($bank->posts->where('tender_status', 1)->count()) {
            $bankHasActivePosts = true;
        }
        

        return view('admin.banks.edit', compact('bank', 'bankHasActivePosts'));
    }


    public function update(StoreBank $request, $id)
    {
        
        $bank = Bank::findOrfail($id);

        if(!isset($request->is_active)){
            $bank->is_active = 0;
        }
        
        if(!isset($request->completed_tenders_is_visible)){
            $bank->completed_tenders_is_visible = 0;
        }
        
 

        $attributesTranslate = [
            'name'              => 'isim',
            'code'              => 'kod',
            'branch'            => 'şube',
            'branch_no'         => 'şube no',
            'account_no'        => 'hesap no',
            'iban'              => 'iban',
            'deposit'           => 'teminat oranı',
            'is_active'         => 'aktiflik',
        ];

        foreach($bank->getAttributes() as $key => $value) { 
            if(array_key_exists($key, $request->validated()) && $bank->$key != $request->validated()[$key] && $key != 'bank_sales_contract_name'  && $key != 'bank_sales_contract_description') {
                Log::channel('Yönetici-Banka-Operasyon')->info('Y-BANKA GÜNCELLEME~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.'~--'.$attributesTranslate[$key].'-- bilgisini güncelledi. Eski değer: '.$bank->$key.'. Yeni değer: '.$request->validated()[$key]);
            }   
        }

        $bank->fill($request->validated());

        $bank->save();

        $request->session()->flash('status', 'Banka bilgileri başarılı bir şekilde güncellendi.');
        return redirect()->route('admin.banks.index');
    }


    public function destroy(Request $request, $id)
    {
        $bank = Bank::findOrfail($id);

        $bank->delete();

        $request->session()->flash('status', 'Banka bilgileri başarılı bir şekilde silindi.');

        return redirect()->route('admin.banks.index');
    }

    public function getBankDepositRatio($id)
    {
        $bank = Bank::findOrFail($id);
        $bankDepositRatio = $bank->deposit;

        return response()->json($bankDepositRatio); 
    }
}
