<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bank;
use App\Models\Document;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DocumentController extends Controller
{

    public function index()
    {
        $documents = Document::with('bank')->get();

        return view('admin.documents.index', compact('documents'));

    }


    public function create()
    {
        
        $banks = Bank::all();
        
        return view('admin.documents.create', compact('banks'));

    }

    public function store(Request $request)
    {
        if(!$request->exists('is_active')) {
            $request->request->add(['is_active' => 0]); 
        }
        else {
            $request->request->add(['is_active' => 1]); 
        }

        $validated = $request->validate([
            'contract_name' => 'required',
            'contract_description' => 'required',
            'bank_id' => 'required',
            'is_active' => 'required',
        ]);
        
        $document = Document::create($validated);

        return redirect()->route('admin.documents.index');
    }

    public function edit(Document $document)
    {
        $banks = Bank::all();
        $document = $document::with('bank')->where('id', $document->id)->first();        
        
        return view('admin.documents.edit', compact('banks', 'document'));
    }

    public function update(Request $request, Document $document)
    {

        if(!$request->exists('is_active')) {
            $request->request->add(['is_active' => 0]); 
        }
        else {
            $request->request->add(['is_active' => 1]); 
        }

        $validated = $request->validate([
            'contract_name' => 'required',
            'contract_description' => 'required',
            'bank_id' => 'required',
            'is_active' => 'required',
        ]);

        $document->fill($validated);

        $document->save();

        $request->session()->flash('status', 'Evrak bilgileri başarılı bir şekilde güncellendi.');
        return redirect()->route('admin.documents.index');
    }
}
