<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\TenderUserPermissionActivationMail;
use App\Mail\TenderUserPermissionMail;
use App\Models\Bank;
use App\Models\City;
use App\Models\District;
use App\Models\Document;
use App\Models\Neighborhood;
use App\Models\NotificationLog;
use Illuminate\Support\Facades\Hash;
use App\Models\Post;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use Spatie\Sitemap\SitemapGenerator;
use Carbon\Carbon;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;
use PDF;
use App\Models\ArchiveFile;
use Illuminate\Support\Facades\File;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('admin');
    } 

    public function index()
    {
        // SitemapGenerator::create('https://propturk.com')->writeToFile(public_path('sitemap.xml'));

        // SitemapGenerator::create('https://propturk.com')
        // ->getSitemap()
        //     ->add(Url::create('/')
        //         ->setLastModificationDate(Carbon::yesterday())
        //         ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        //         ->setPriority(1))
        // ->add(Url::create('/contact')
        //         ->setLastModificationDate(Carbon::yesterday())
        //         ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        //         ->setPriority(1))
        // ->add(Url::create('/register')
        //         ->setLastModificationDate(Carbon::yesterday())
        //         ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        //         ->setPriority(1))
        // ->add(Url::create('/login')
        //         ->setLastModificationDate(Carbon::yesterday())
        //         ->setChangeFrequency(Url::CHANGE_FREQUENCY_DAILY)
        //         ->setPriority(1))
        // ->writeToFile(public_path('sitemap.xml'));  
        
        
    	if(Auth::user()->is_admin == 1) {
    		$users = User::whereNotIn('is_admin', [1])->latest()->get();	
    	}
    	else {
    		$users = User::whereNotIn('is_admin', [1, 2])->latest()->get();	
    	}
        
        
        return view('admin.users.index', [
            'users' => $users,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $posts = Post::where('tender_status', 1)->with('postable', 'bank')->latest()->get();
        // dd($posts);
        return view('admin.users.create', ['posts' => $posts]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreUserRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator = $request->validate([
            'name'              => ['required', 'string', 'max:255'],
            'surname'           => ['required', 'string', 'max:255'],
            'email'             => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password'          => ['required', 'string', 'min:8'],
            'phone_number'      => ['required'],
            'identity_number'   => ['nullable'],
            'is_admin'          => ['required'],
            'company_name' => ['nullable', 'string'],
            'company_tax_office' => ['nullable', 'string'],
            'company_tax_id' => ['nullable', 'string'],

        ]);

        
        DB::beginTransaction();

        try { 
             $userArray = $request->only('name', 'surname', 'identity_number', 'email', 'phone_number', 'password', 'is_admin',
            'company_name', 'company_tax_office', 'company_tax_id');


            $userArray['slug'] = SlugService::createSlug(User::class, 'slug', $userArray['name'].'-'.$userArray['surname'].'-'.Str::random(5));
            $phoneNumber =  substr(preg_replace('/[^0-9]/', '', $userArray['phone_number']), 1);

            if(Auth::user()->is_admin == 2 && request()->is_admin != 0) {
                $userArray['is_admin'] = 0;

                Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-KULLANICI KAYIT~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ÇALIŞAN YETKİSİZ BİR İŞLEME BAŞVURMUŞTUR.');
            }

            $user = User::create([
                'name'              => $userArray['name'],
                'email'             => $userArray['email'],
                'password'          => Hash::make($userArray['password']),
                'surname'           => $userArray['surname'],
                'phone_number'      => $phoneNumber,
                'identity_number'   => $userArray['identity_number'],
                'is_admin'          => $userArray['is_admin'],
                'slug'              => $userArray['slug'],
                'company_name'      => $userArray['company_name'],
                'company_tax_office'=> $userArray['company_tax_office'],
                'company_tax_id'    => $userArray['company_tax_id'],
            ]);



            $postArray = $request->except('_token', 'name', 'surname', 'identity_number', 'email', 
                'phone_number', 'password', 'password_confirmation', 'is_admin', 'slug', 'company_name', 'company_tax_office', 'company_tax_id');
            $postIds = [];
            foreach($postArray as $key => $value){
                if($value){
                    array_push($postIds, $key);
                }
            }
            $this->sendPermissionMail($postIds, $user);
            $user->posts()->attach($postIds);

            DB::commit();
            Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-KULLANICI KAYIT~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ID: '.$user->id.' E-mail: '.$user->email. ' İsim: '.$user->name.' Soyisim: '.$user->surname);

            return redirect()->route('admin.users.index')->with('status', 'Kullanıcı başarıyla oluşturuldu.');
        }
        catch(Exception $e) {
            DB::rollback();
            
            return redirect()->route('admin.users.index')->with('status', 'Kullanıcı oluşturulurken hata meydana geldi!!');
        }
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        $posts = Post::where('tender_status', 1)->with('postable', 'bank')->latest()->get();

        $userPermissions = $user->posts->where('tender_status', 1);
        $userPermissionArray = [];

        foreach($userPermissions as $userPermission){
            array_push($userPermissionArray, $userPermission->id);
        }

        // dd($userPermissionArray);
        return view('admin.users.edit', ['user' => $user, 'posts' => $posts, 'userPermissionArray' => $userPermissionArray]);
    }


    public function update(Request $request, $id)
    {

        $user = User::findOrFail($id);

        $validator = $request->validate([
            'name'              => ['required', 'string', 'max:255'],
            'surname'           => ['required', 'string', 'max:255'],
            'email'             => ['required', 'string', 'email', 'max:255'],
            'password'          => ['nullable', 'string', 'min:8', 'confirmed'],
            'phone_number'      => ['required'],
            'identity_number'   => ['nullable'],
            'is_admin'          => ['required'],
            'slug'              => ['nullable'],
            'address'           => ['nullable'],   
            'company_name'      => ['nullable', 'string'],
            'company_tax_office'=> ['nullable', 'string'],
            'company_tax_id'    => ['nullable', 'string'],
 
         ]);

         DB::beginTransaction();
         try {  
            $userArray = $request->only('name', 'surname', 'identity_number', 'email', 'phone_number', 'password', 'is_admin', 'address',
            'company_name', 'company_tax_office', 'company_tax_id');

            
            $userArray['phone_number'] =  substr(preg_replace('/[^0-9]/', '', $userArray['phone_number']), 1);

            $attributesTranslate = [
                'name'            => 'isim',
                'surname'         => 'soyisim',
                'phone_number'    => 'telefon numarası',
                'identity_number' => 'kimlik numarası',
                'sms_permission'  => 'sms izni',
                'email'           => 'email',
                'is_admin'        => 'kullanıcı yetkisi',
                'address'         => 'adres',
                'company_name'    => 'şirket ünvanı',
                'company_tax_office' => 'şirket vergi dairesi',
                'company_tax_id'     => 'şirket vergi no',

            ];

            foreach($user->getAttributes() as $key => $value) { 
                if($key != 'password' && array_key_exists($key, $userArray) && $user->$key != $userArray[$key]) {
                    Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-KULLANICI GÜNCELLEME~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ID: '.$user->id.' --'.$attributesTranslate[$key].'-- bilgisini güncelledi. Eski değer: '.$user->$key.'. Yeni değer: '.$userArray[$key]);
                }   
            }

            if(Auth::user()->is_admin == 2 && request()->is_admin != 0) {
                $userArray['is_admin'] = 0;

                Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-KULLANICI KAYIT~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ÇALIŞAN YETKİSİZ BİR İŞLEME BAŞVURMUŞTUR.');
            }

            if($userArray['password'] == null)
            {
                $user->name = $userArray['name'];
                $user->surname = $userArray['surname'];
                $user->email = $userArray['email'];
                $user->identity_number = $userArray['identity_number'];
                $user->phone_number = $userArray['phone_number'];
                $user->is_admin = $userArray['is_admin'];
                $user->address = trim($userArray['address']);
                $user->company_name = $userArray['company_name'];
                $user->company_tax_office = $userArray['company_tax_office'];
                $user->company_tax_id = $userArray['company_tax_id'];

            }
            else
            {
                $user->name = $userArray['name'];
                $user->surname = $userArray['surname'];
                $user->email = $userArray['email'];
                $user->identity_number = $userArray['identity_number'];
                $user->phone_number = $userArray['phone_number'];
                $user->is_admin = $userArray['is_admin'];
                $user->address = trim($userArray['address']);
                $user->company_name = $userArray['company_name'];
                $user->company_tax_office = $userArray['company_tax_office'];
                $user->company_tax_id = $userArray['company_tax_id'];
                $user->password = Hash::make($userArray['password']);
                Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-KULLANICI GÜNCELLEME~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.'~'.'ID: '.$user->id.' --'.'şifre'.'-- bilgisini güncelledi');

            }
            
            $user->save();
            
            $oldPostIds = $user->posts->pluck('id')->toArray();
            $oldFinishedPostIds = $user->posts->where('tender_status', 2)->pluck('id')->toArray();
            //dd($activeOldPostIds);
            $postArray = $request->except('_token', '_method', 'name', 'surname', 'identity_number', 
                'email', 'phone_number', 'password', 'password_confirmation', 'is_admin', 'slug', 'address', 'company_name', 'company_tax_office', 'company_tax_id');
            $postIds = [];
            $mailPostIds = [];

            $allPosts = Post::all();
            
            foreach($postArray as $key => $value){
                if(!in_array($key, $oldPostIds)) {
                    array_push($mailPostIds, $key);
                }
                
                if($value){
                    array_push($postIds, $key);
                    array_push($oldFinishedPostIds, $key);
                }
            }
            
            $activeOldPostIds = $user->posts->where('tender_status', 1)->pluck('id')->toArray();

            foreach($activeOldPostIds as $activePostId) {
                if(!in_array($activePostId, $postIds)) {

                    Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-İHALE İZNİ~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ID: '.$user->id.' E-mail: '.$user->email. ' İlan Kodu: '.$allPosts->where('id', $activePostId)->first()->tender_code.' yetkisi kaldırıldı.');
                }
            }

            if(!empty($mailPostIds)) {
                $this->sendPermissionMail($mailPostIds, $user);
            }
            

            $user->posts()->sync($oldFinishedPostIds);
            
            DB::commit();
            $request->session()->flash('status', 'Kullanıcı başarıyla güncellendi.');
            return redirect()->route('admin.users.index');
        }
        catch(Exception $e) {
            DB::rollback();
            
            return redirect()->route('admin.users.index')->with('status', 'Kullanıcı güncellenirken hata meydana geldi!!');
        }
    }


    public function destroy(Request $request, $id)
    {
        $user = User::findOrFail($id);
        
        $user->delete();

        $request->session()->flash('status', 'Kullanıcı başarıyla silindi.');

        return redirect()->route('admin.users.index');
    }

    public function sendPermissionMail($postIds, $user) {
        
        foreach($postIds as $postId) {
            $post = Post::findOrFail($postId);

            $notificationLogType = 'mail';
            $notificationLogName = 'Mail - Kullanıcı ihale teklif verme izin bildirimi'; //TenderUserPermissionActivationSMS
            NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, NULL);

            Mail::to($user->email)->queue(
                new TenderUserPermissionActivationMail($user, $post)
            );
            
            $notificationLogType = 'sms';
            $notificationLogName = 'SMS - Kullanıcı ihale teklif verme izin bildirimi'; //TenderUserPermissionActivationSMS
            $notificationLogDesc = str_replace('%20', ' ', TenderUserPermissionActivationSMS($user, $post));
            NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);

            sendSms($user, TenderUserPermissionActivationSMS($user, $post));

            Log::channel('Yönetici-Kullanıcı-Operasyon')->info('Y-İHALE İZNİ~'.'ID: '.Auth::user()->id.' E-mail: '.Auth::user()->email.' '.'~'.'ID: '.$user->id.' E-mail: '.$user->email. ' İlan Kodu: '.$post->tender_code.' yetki verilmiştir.');

        }
    }

    public function sendCustomMail($id) {
        $user = User::findOrFail($id);
        $posts = Post::with('postable', 'bank')->get();
        


        return view('admin.users.send-custom-mail', ['user' => $user, 'posts' => $posts]);
    }

    public function sendCustomMailUser(Request $request, $id) {
    
        if($request->contracts != null) {    
            $user = User::findOrFail($id);
            $post = Post::findOrFail($request->post);
            $postProperty = $post->postable;
            $bank = $post->bank;
            
            $city = $postProperty->country;
            $district = $postProperty->district;
            $neighborhood = $postProperty->neighborhood;



            $dataBank = [
                'post_code' => $post->code,
                'deed_infos' => $city.' İli, '.$district.' İlçesi, '. $postProperty->neighborhood.', '.$postProperty->city_block_no.' Ada, '.$postProperty->parcel_no." No'lu Parsel, ".$postProperty->independet_section_no."No'lu Bağımsız Bölüm",
                'city' => $city,
                'district' => $district, 
                'post_address' => $postProperty->address,
                'deposit_value' => number_format(($post->start_price / 100) * $bank->deposit, 0, '.', '.'),
                'propturk_deposit_value' => number_format($post->deposit_ratio, 0, '.', '.'), //değiştirildi.
                'post_price' => number_format(($post->start_price), 0, '.', '.'),
                'user_name' => $user->name.' '.$user->surname,
                'user_identity_number' => $user->identity_number,

                'user_phone_number' => $user->phone_number,
                'user_email' => $user->email,
                'user_address' => $user->address,

                'company_name' => $user->company_name,
                'company_tax_office' => $user->company_tax_office,
                'company_tax_id' => $user->company_tax_id,

            ];
            
            $contractArray = [];

            $notificationLogType = 'mail';
            $notificationLogName = 'Mail - Kullanıcı ihale katılım talebi bildirimi'; //TenderUserPermissionMail
            $mailNotificationLog = NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, NULL);

        
            foreach ($request->contracts as $contractId) {
                $contract = Document::where('id', $contractId)->first();

                $contract->contract_description = Str::replace("{{ihaleKodu}}", $dataBank['post_code'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{ihaleKonumBilgileri}}", $dataBank['deed_infos'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{ihaleAcikAdresi}}", $dataBank['post_address'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{bankaDepozito}}", $dataBank['deposit_value'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriAdi}}", $dataBank['user_name'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriTcKimlikNo}}", $dataBank['user_identity_number'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriTelefonNumarasi}}", $dataBank['user_phone_number'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriEmail}}", $dataBank['user_email'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriAdresi}}", $dataBank['user_address'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{tasinmazBaslangicFiyati}}", $dataBank['post_price'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{propturkDepozito}}", $dataBank['propturk_deposit_value'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{ihaleIlBilgisi}}", $dataBank['city'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{ihaleIlceBilgisi}}", $dataBank['district'], $contract->contract_description);
               $contract->contract_description = Str::replace("{{musteriSirketUnvani}}", $dataBank['company_name'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriSirketVergiDairesi}}", $dataBank['company_tax_office'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{musteriSirketVergiNo}}", $dataBank['company_tax_id'], $contract->contract_description);
                $contract->contract_description = Str::replace("{{bugunTarih}}", now()->format('d/m/Y'), $contract->contract_description);

                $contractHtmlData = '
                    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                        <meta name="color-scheme" content="light">
                        <meta name="supported-color-schemes" content="light">
                        <style>
                            body { font-family: DejaVu Sans, sans-serif; }
                        </style>
                    </head>
                    <body>
                        '.$contract->contract_description.'
                    </body>
                ';

                $contractPdfEncodeData = base64_encode(PDF::loadHTML($contractHtmlData)->setPaper('A4', 'portrait')->output());
                
                $filePath = 'storage/mail_file_archive/'.$post->id.'/'.$mailNotificationLog->id.'/'.$user->id;
                File::makeDirectory($filePath, 0777, true, true);
                $fileNameWithPath = $filePath.'/'.$user->name.'-'.$user->surname.'-'.str_replace(' ', '-', $contract->contract_name).'-'.rand(1, 100).'.pdf';
                $pdfFile = PDF::loadHTML($contractHtmlData)->setPaper('A4', 'portrait')->setWarnings(false)->save($fileNameWithPath);
                
                $archiveFile = new ArchiveFile([
                    'file_name' => $fileNameWithPath,
                    'size' => 1,
                    'notification_log_id' => $mailNotificationLog->id,
                    'post_id' => $post->id,
                    'user_id' => $user->id
                ]);
                $archiveFile->save();

                array_push($contractArray, [
                    'contractPdfHtmlData' => $contractPdfEncodeData,
                    'contractName' => $contract->contract_name
                ]);
            }            


        
            Mail::to($user->email)->queue(
                new TenderUserPermissionMail($user, $post, $contractArray, $bank)
            );



            $request->session()->flash('status', 'İlgili kullanıcıya mail başarıyla gönderildi.');
        }
        else {
            $request->session()->flash('status', 'İlgili kullanıcıya mail gönderimi başarısız.');            
        }

        return redirect()->route('admin.users.index');
    }

    public function getBankContract($id) {
        $post = Post::findOrFail($id);
        $bank = $post->bank;
        $contracts = Document::where('bank_id', $bank->id)->where('is_active', true)->get();

        $propturkBank = Bank::where('name', 'propturk')->first();
        $propturkContracts = Document::where('bank_id', $propturkBank->id)->get();

        $contracts = $contracts->merge($propturkContracts);

        foreach ($contracts as $contract) {
            if(in_array($contract->id, $post->contracts)) {
                $contract->is_checked = 1;
            }
            else {
                $contract->is_checked = 0;
            }
        }
        return response()->json(['post' => $post, 'bank' => $bank, 'contracts' => $contracts]);
    }
}