<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;



    //protected $redirectTo = RouteServiceProvider::HOME;


    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function validateLogin(Request $request)
    {
        $request->validate([
            $this->username() => 'required|string',
            'password' => 'required|string',
            'g-recaptcha-response' => 'required|recaptcha'
        ]);
    }

    protected function sendLoginResponse(Request $request)
    {
        $request->session()->regenerate();

        $this->clearLoginAttempts($request);

        if ($response = $this->authenticated($request, $this->guard()->user())) {
            return $response;
        }

        return $request->wantsJson()
                    ? new JsonResponse([], 204)
                    : redirect()->intended($this->redirectPath())->with('status', 'Başarı ile giriş yaptınız.');
    }
    
    public function redirectTo() {

        Log::channel('Kullanıcı-Giriş')->info('KULLANICI GİRİŞ~'.Auth::user()->email." - ".Auth::user()->name." ".Auth::user()->surname." "."giriş yaptı.");

        if(Auth::user()->is_admin == 0) {
           // return redirect()->route('home');
            return '/';
        }
        else {
            return '/admin/home';
        }

      }

    protected function logout(Request $request)
    {
        Log::channel('Kullanıcı-Giriş')->info('KULLANICI ÇIKIŞ~'.Auth::user()->email." - ".Auth::user()->name." ".Auth::user()->surname." "."çıkış yaptı.");

        $this->guard()->logout();

        $request->session()->flush();

        $request->session()->regenerate();

        return redirect('/');
    }
}
