<?php

namespace App\Http\Controllers;

use App\Http\Controllers\User\TenderController;
use App\Models\Bank;
use App\Models\City;
use App\Models\District;
use App\Models\Offer;
use App\Models\Post;
use App\Models\PostView;
use App\Models\Property;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;


class HomeController extends Controller
{

    /*
    private $bankName;

    public function __construct(Request $request)
    {
        dump($request->all());
        $this->bankName = $request->bankName;
    }
*/

    
    public function index() {
        
        $cities = City::all();  
            
        if(isset(Auth::user()->favorite_posts)){    
            $favoritePosts = unserialize(Auth::user()->favorite_posts); 
        }   
        else{   
            $favoritePosts = [];    
        }   
        //$favoritePosts = unserialize(Auth::user()->favorite_posts);


        $offeredPosts = Post::where([['tender_status', 1], ['end_time', '!=', NULL]])->with('postable', 'bank')->get();
        foreach($offeredPosts as $post){
            $now = Carbon::now('Europe/Istanbul');
            $endTimeStr = $post->end_time;
            $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
            if(!$now->gt($endTime)){
                $diffInSeconds = $endTime->diffInSeconds($now);
            }
            else{
                $diffInSeconds = 0;
                $post->tender_status = 2;
            }
            $post->diffinseconds = $diffInSeconds;
        }
        $completedPosts = Post::where('tender_status', '=',  2)->with('postable', 'bank')->get();
        $nonOfferedPosts = Post::where([['tender_status', '=',  1], ['end_time', '=', NULL]])->with('postable', 'bank')->get();

        //dd($posts->first()->postable->property_type);  property örneği
        //dd($posts->first()->bank->name);  banka örneği
        //dd($posts->first()->postable->slug); slug örneği
        // dd(Storage::allFiles($posts->first()->images_folder)[0]);
        // dd( Storage::url($posts->first()->images_folder));

        if(session('subdomain')) {
            $sessionBank = Bank::where('code', session('subdomain'))->first();
            if($sessionBank != NULL) {
                $offeredPosts = $offeredPosts->where('bank_id', $sessionBank->id);
                $nonOfferedPosts = $nonOfferedPosts->where('bank_id', $sessionBank->id); 
            }

        }
        // dd($offeredPosts);
        return view('home.index', compact('offeredPosts', 'nonOfferedPosts', 'favoritePosts', 'cities', 'completedPosts'));
    }

    public function show($slug) {

        if(isset(Auth::user()->favorite_posts)){    
            $favoritePosts = unserialize(Auth::user()->favorite_posts); 
        }   
        else{   
            $favoritePosts = [];    
        }

        $now = Carbon::now('Europe/Istanbul');


        $post = Property::where('slug', $slug)->first()->post;

        
        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');

        $endTimeClock = $endTime->format('H:i');
        $endTimeDay = $endTime->day;
        $endTimeMonth = config('enums.months')[$endTime->format('F')];
        $endTimeYear = $endTime->year;

        if($post->tender_status != 1 || $now->gt($endTime)) {
            return redirect()->route('home');
        } 

        if(!session('IsRedirectingFromBidForViewCount')) {
            PostView::createViewLog($post);
        }

        if($this->isFirstOffer($post->id)) {
            $newOffer = $post->current_price;
        }
        else {
            $newOffer = $post->current_price + $post->offer_step;
        }

        
        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
        $now = Carbon::now('Europe/Istanbul');
        if(!$now->gt($endTime)){
            $diffInSeconds = $now->diffInSeconds($endTime);
        }
        else{
            $diffInSeconds = 0;
        }

        $authUser = Auth::user();
        if($authUser) {
            $mailedUsers = unserialize($post->mailed_users);
            $userTenderStatus = 0;
            //dd($this->isUserAuthorized($post->id, $authUser->id));
            if($this->isUserAuthorized($post->id, $authUser->id))
            {
                $userTenderStatus = 2;
            }
            elseif(is_array($mailedUsers) && in_array($authUser->id, $mailedUsers))
            {
                $userTenderStatus = 1;
            }
            elseif(is_array($mailedUsers) && !in_array($authUser->id, $mailedUsers))
            {
                $userTenderStatus = 0;
            }

            return view('property.index', [
                'property' => $post->postable, 
                'newOffer' => $newOffer, 
                'diffInSeconds' => $diffInSeconds,
                'userTenderStatus' => $userTenderStatus,
                'favoritePosts' => $favoritePosts,
                'endTimeClock' => $endTimeClock,
                'endTimeDay' => $endTimeDay,
                'endTimeMonth' => $endTimeMonth,
                'endTimeYear' => $endTimeYear
            ]);

        }

        //dd($diffInSeconds);
        return view('property.index', [
            'property' => $post->postable, 
            'newOffer' => $newOffer, 
            'diffInSeconds' => $diffInSeconds,
            'favoritePosts' => $favoritePosts,
            'endTimeClock' => $endTimeClock,
            'endTimeDay' => $endTimeDay,
            'endTimeMonth' => $endTimeMonth,
            'endTimeYear' => $endTimeYear
        ]);
    }

    public function searchFilter(Request $request, Property $property){ 
        // dd($request->all());
        $min = $request->min_price;
        $max = $request->max_price;
        $minValue = str_replace('.', '', $min);
        $maxValue = str_replace('.', '', $max);

        $property = $property->newQuery();  
        if(!is_null($request->property_type)){  
            $property->where('property_type', $request->property_type); 
        }
        if(!is_null($request->city) && $request->ziraatKatilimSelector == 'ziraat-katilim') {
            if(count($request->city) == 1) {
                if(!is_null($request->district)) {
                    $property->where('district', District::where('id', $request->district)->first()->name);
                }
                else {
                    $property->where('country', City::where('id', $request->city)->first()->name);
                }
            }
            else {
                $tempCityNameArr = [];
                foreach ($request->city as $key => $value) {
                    $tempCityNameArr[$key] =  City::where('id', $value)->first()->name;
                }
                $property->whereIn('country', $tempCityNameArr);    
            }
        }
        else if(!is_null($request->city)){  
            $property->where('country', $request->city);    
        }   
        if(!is_null($request->g_no)){   
            $property->whereHas('post' , function($query) use($request) {   
                $query->where('code', $request->g_no);  
            }); 
                
        }
        // if(!$request->ziraatKatilimSelector == 'ziraat-katilim') {
            if(!is_null($request->tender_status)){  
                switch($request->tender_status){    
                    case 1: 
                        $property->whereHas('post', function($query) {  
                            $query->where('end_time', '!=', NULL)
                                ->where('tender_status', 1);
                                
                        }); 
                        break;  
                    case 2: 
                        $property->whereHas('post' , function($query) { 
                            $query->where('end_time', '=', NULL)
                                ->where('tender_status', 1);    
                        }); 
                        break;  
                    case 3: 
                        $property->whereHas('post' , function($query) { 
                            $query->where('is_fast_buy', '=', 1)
                                ->where('tender_status', 1);    
                        }); 
                        break;  
                }   
            }   
            else{   
                $property->whereHas('post' , function($query) { 
                    $query->where('tender_status', 1);  
                });     
            }

            if($request->tender_status == 3){
                $priceSearch = 'fast_buy_price';
            }
            else{
                $priceSearch = 'current_price';
            }
        // }


        if(!is_null($request->min_price) && !is_null($request->max_price)){
            $property->whereHas('post' , function($query) use($priceSearch, $minValue, $maxValue){  
                $query->where([[$priceSearch, '>=', $minValue],[$priceSearch, '<=', $maxValue]]);   
            });
        }
        elseif(!is_null($request->min_price)){
            $property->whereHas('post' , function($query) use($priceSearch, $minValue){ 
                $query->where($priceSearch, '>=', $minValue);   
            });
        }
        elseif(!is_null($request->max_price)){
            $property->whereHas('post' , function($query) use($priceSearch, $maxValue){ 
                $query->where($priceSearch, '<=', $maxValue);   
            });
        }
      
        if(session('subdomain')) {
            $sessionBank = Bank::where('code', session('subdomain'))->first(); 
            if($sessionBank != NULL) {
                $property->whereHas('post' , function($query) use($sessionBank){    
                    $query->where('bank_id', $sessionBank->id); 
                });
            }
        }

        $properties = $property->with('post')->get();   

 

    
        if(isset(Auth::user()->favorite_posts)){    
            $favoritePosts = unserialize(Auth::user()->favorite_posts); 
        }   
        else{   
            $favoritePosts = [];    
        } 


        foreach($properties as $property) {
            $property->current_price = $property->post->current_price;
            if($property->post->end_time != NULL) {
                $now = Carbon::now('Europe/Istanbul');
                $endTimeStr = $property->post->end_time;
                $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
                if(!$now->gt($endTime)){
                    $diffInSeconds = $endTime->diffInSeconds($now);
                }
                else{
                    $diffInSeconds = 0;
                    $property->post->tender_status = 2;
                }
                $property->post->diffinseconds = $diffInSeconds;
            }
        }

        $cities = City::all();

        // $old_tender = $request->tender_status;
        // $old_propertyType = $request->property_type;
        // $old_city = $request->city;
        // $old_min = $minValue;
        // $old_max = $maxValue;
        
        // $request->session()->keep([
        //     'tender_status' => $request->tender_status,
        //     'property_type' => $request->property_type,
        //     'city' => $request->city,
        //     'min_price' => $request->min_price,
        //     'max_price' => $request->max_price, 
        // ]);
        // dd(isset($old_min));


        // 
        // dd($properties->pluck('id')->toArray());
        if($request->property_sort == 1) {
            $properties = $properties->sortBy('current_price');
        }
        else if($request->property_sort == 2) {
            $properties = $properties->sortByDesc('current_price');
        }
        
        if($request->ziraatKatilimSelector == 'ziraat-katilim') {
            $z = 1;
            // dd($properties[1]->post);
            return view('home.index', compact('properties', 'cities', 'z'));
        }

        return view('search.search-result', compact('properties', 'cities'));
    }
    
    public function tenderUserPermissionMail($slug)
    {   
        $user = User::findOrFail(Auth::user()->id);

        $property = Property::where('slug', $slug)->first();
        TenderController::permissionMail($user, $property->post, $property);
        
        if(!is_array(unserialize($property->post->mailed_users))) {
            $mailedUsers = [];
        }
        else {
            $mailedUsers = unserialize($property->post->mailed_users);
        }
        array_push($mailedUsers, $user->id);
        $property->post->mailed_users = serialize($mailedUsers);
        $property->post->save();

        if(!is_array(unserialize($user->mailed_posts))) {
            $mailedPosts = [];
        }
        else {
            $mailedPosts = unserialize($user->mailed_posts);
        }
        array_push($mailedPosts, $property->post->id);
        $user->mailed_posts = serialize($mailedPosts);
        $user->save();

        return redirect()->route('post.show', ['slug' => $slug])->with('status', 'İhale süreci detayları kayıtlı mail hesabınıza gönderilmiştir.');
    }

    public function isFirstOffer($postId){
        $offers = Offer::where('post_id', $postId)->get();
        return $offers->isEmpty();
    }

    public function isUserAuthorized($postId, $userId){
        $post = Post::findOrFail($postId);
        $permissions = $post->users->pluck('id')->toArray();
        return in_array($userId, $permissions);
    }

    public function contact() {

        return view('contact.index');
    }
    public function aboutus() {

        return view('about.aboutus');
    }

    public function ourjob() {

        return view('about.ourjob');
    }

    public function buyRealestate() {

        return view('about.buy-realestate');
    }

    public function shortURLtoURL($short_link_code) {
        
        $slug = Post::where('short_link_code', $short_link_code)->first()->postable->slug;
        
        return redirect()->route('post.show', compact('slug'));
    }

    public function cookiesPolicy()
    {
        return view('about.cookies-policy');
    }
    public function privacyPolicy()
    {
        return view('about.privacy-policy');
    }
    public function kvkk()
    {
        return view('about.kvkk');
    }

    public function denemeSearch(Request $request)
    {
        dd($request->all());
    }

    public function getDistrictsHome($id) {

        $districts = City::where('id', $id)->get()->first()->district()->pluck('name', 'id');

        $districtsArray = [];

        foreach ($districts as $key => $value) {
            $districtsArray[] = array('id'=> $key, 'text' => $value);
        }  
        // dd($districtsArray);

        return response()->json($districtsArray); 
    }
}