<?php

namespace App\Http\Controllers\User;

use App\Events\TenderOfferValueUpdateEvent;
use App\Http\Controllers\Controller;
use App\Mail\HigherOfferMail;
use App\Mail\TenderLoserMail;
use App\Mail\TenderUserPermissionMail;
use App\Mail\TenderWinnerMail;
use App\Models\Bank;
use App\Models\City;
use App\Models\District;
use App\Models\Document;
use App\Models\Neighborhood;
use App\Models\NotificationLog;
use App\Models\Offer;
use App\Models\Post;
use App\Models\Property;
use App\Models\User;
use PDF;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;
use App\Models\ArchiveFile;
use Illuminate\Support\Facades\File;

class TenderController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function bidCheck(Request $request, $slug){
        $property = Property::where('slug', $slug)->first();
        $post = $property->post;
        $postId = $post->id;
        //$post = Post::findOrFail($postId);
        $offer = new Offer;
        $user = Auth::user();

        //dd(request()->all());

        //dump(str_replace('.', '', $request->all()['offer_amount']));
        //$request->offer_amount = str_replace('.', '', $request->all()['offer_amount']);
        $request->merge([
            'offer_amount' => str_replace('.', '', $request->all()['offer_amount']),
        ]);
        //dd($request->all());
        $currentPrice = $post->current_price;
        $offerStep = $post->offer_step;

        $permissionCheck = $this->isUserAuthorized($postId, $user->id);
        $firstOfferCheck = $this->isFirstOffer($postId);
        $request->validate([
            'offer_amount' => 'offer_check:'.$currentPrice.',' .$offerStep.',' .$firstOfferCheck
        ]);
        $requestArray = $request->all();
        $offerAmount = $request->offer_amount;
        
        $now = Carbon::now('Europe/Istanbul');
        $nowStr = $now->toDateTimeString();

        $firstOfferTime = Carbon::parse($post->first_offer_time);
        $firstOfferTimeStr = $firstOfferTime->toDateTimeString();
        
        $endTimeStr = $post->end_time;
        $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
        
        //dd($updEndTimeStr);
        if($permissionCheck && $post->tender_status == 1){
            if($firstOfferCheck){
                Log::channel('İlan')->info('İLK TEKLİF~'.'ID: '.$user->id.' E-mail: '.$user->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleye ilk teklifi vermiştir.');

                $firstEndTime = Carbon::now('Europe/Istanbul')->addMinutes($post->duration);
                $firstEndTime = $this->checkEndTime($firstEndTime);
                $firstEndTimeStr = $firstEndTime->toDateTimeString();
                $post->current_price = $offerAmount;
                $post->first_offer_time = $nowStr;
                $post->is_fast_buy = false;
                //TODO::mail servisi eklenecek.
                $post->end_time = $firstEndTimeStr;
                $post->winner_id = $user->id;
                $post->save();

                $offer->price = $offerAmount;
                $offer->user_id = $user->id;
                $offer->post_id = $postId;
                $offer->save();
                $request->session()->flash('status', 'Başarıyla teklif verdiniz.');

            }
            else{
                if($now->gt($endTime)){
                    Log::channel('İlan')->info($post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihale başarıyla sonlanmıştır.');
          
                    $post->tender_status = 2;
                    $this->tenderWinnerMail($post);
                    $this->tenderLoserMail($post);
                    $post->save(); 
                    $request->session()->flash('status', 'İhale süreci tamamlandı, teklifiniz geçersiz sayılmıştır.');
                    return redirect()->route('home');
                }
                elseif($endTime->diffInMinutes($now) < 30){
                    Log::channel('İlan')->info('TEKLİF~'.'ID: '.$user->id.' E-mail: '.$user->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleye '.$offerAmount.' TL fiyatıyla teklif vermiştir.');

                    $endTime = $now->addMinutes(30)->toDateTimeString();
                    //dd($endTime);
                    $post->end_time = $endTime;
                    $post->current_price = $offerAmount;
                    $post->winner_id = $user->id;
                    $post->save();

                    $offer->price = $offerAmount;
                    $offer->user_id = $user->id;
                    $offer->post_id = $postId;
                    $offer->save();
                    $this->higherOfferMail($user, $post);


                    $request->session()->flash('status', 'Başarıyla teklif verdiniz.');

                }
                else{
                    Log::channel('İlan')->info('TEKLİF~'.'ID: '.$user->id.' E-mail: '.$user->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleye '.$offerAmount.' TL fiyatıyla teklif vermiştir.');

                    $post->current_price = $offerAmount;
                    $post->winner_id = $user->id;
                    $post->save();

                    $offer->price = $offerAmount;
                    $offer->user_id = $user->id;
                    $offer->post_id = $postId;
                    $offer->save();
                    $this->higherOfferMail($user, $post);
                    $request->session()->flash('status', 'Başarıyla teklif verdiniz.');
                }
            }

            //web socket integration-----
            $post->new_offer = number_format($post->current_price + $post->offer_step, 0, '.', '.');
            $post->current_price = number_format($post->current_price, 0, '.', '.');

            $endTimeStr = $post->end_time;
            $endTime = Carbon::parse($endTimeStr, 'Europe/Istanbul');
            $now = Carbon::now('Europe/Istanbul');
            if(!$now->gt($endTime)){
                $post->diffInSeconds = $now->diffInSeconds($endTime);
            }
            else{
                $post->diffInSeconds = 0;
            }
            $post->pageRefreshForFirstOffer = 0;
            if($post->first_offer_time != NULL && $now->diffInSeconds($post->first_offer_time) < 5) {
                $post->pageRefreshForFirstOffer = 1; 
            }

            // $post->alertChange = 0;
            // if(Auth::user()->id == $property->post->winner_id) {
            //     $post->alertChange = 1;
            // }



            // if(in_array(Auth::user()->id, $property->post->offers->pluck('user_id')->toArray()) && Auth::user()->id != $property->post->winner_id) {
            //     $post->alertChange = 2;
            // }

            $post->offersIds = $post->offers->pluck('user_id')->toArray();


            $post->endTimeClock = $endTime->format('H:i');
            $post->endTimeDay = $endTime->day;
            $post->endTimeMonth = config('enums.months')[$endTime->format('F')];
            $post->endTimeYear = $endTime->year;
 
            event(new TenderOfferValueUpdateEvent($post));
            //web socket integration-----
        }
        

        return redirect()->route('post.show', ['slug' => $slug])->with('IsRedirectingFromBidForViewCount', true);
    }

    public function fastBuy($slug){
        $post = Property::where('slug', $slug)->first()->post;
        $offer = new Offer;
        $user = Auth::user();

        if(!$post->is_fast_buy) {
            return redirect()->route('home');
        }

        Log::channel('İlan')->info('HIZLI SATIN AL~'.'ID: '.$user->id.' E-mail: '.$user->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleyi hızlı satın al butonuyla satın almıştır.');

        $post->winner_id = $user->id;
        $post->current_price = $post->fast_buy_price;
        $post->tender_status = 2;
        $post->save();  
        event(new TenderOfferValueUpdateEvent($post));
                
        $offer->price = $post->fast_buy_price;
        $offer->user_id = $user->id;
        $offer->post_id = $post->id;
        $offer->save();
        $this->tenderWinnerMail($post);
        $this->tenderLoserMail($post);

        return redirect()->route('home')->with('status', 'Satın alma işleminiz başarıyla gerçekleşmiştir.');
    }

    public function isFirstOffer($postId){
        $offers = Offer::where('post_id', $postId)->get();
        return $offers->isEmpty();
    }

    public function isUserAuthorized($postId, $userId){
        $post = Post::findOrFail($postId);
        $permissions = $post->users->pluck('id')->toArray();
        return in_array($userId, $permissions);
    }

    public function checkEndTime(Carbon $endTime){
        if($endTime->isSaturday()){
            $endTime->addDay(2);
            $endTime->setHour(12);
            $endTime->setMinutes(30);
            $endTime->setSecond(0);
            return $endTime;
        }
        elseif($endTime->isSunday()){
            $endTime->addDay(1);
            $endTime->setHour(12);
            $endTime->setMinutes(30);
            $endTime->setSecond(0);
            return $endTime;
        }
        return $endTime;
    }

    public static function permissionMail($user, $post, $postProperty) {
        //$user status update
        
        $bank = $post->bank;
        
        // $city = City::findOrFail($postProperty->country)->name;
        
        // $district = District::findOrFail($postProperty->district)->name;
        // $neighborhood = Neighborhood::where('id', $postProperty->neighborhood)->first();
        // if($neighborhood != NULL) {
        //     $neighborhood = $neighborhood->name; 
        // }
        
        $dataBank = [
            'post_code' => $post->code,
            'deed_infos' => $postProperty->country.' İli, '.$postProperty->district.' İlçesi, '. $postProperty->neighborhood.', '.$postProperty->city_block_no.' Ada, '.$postProperty->parcel_no." No'lu Parsel, ".$postProperty->independet_section_no."No'lu Bağımsız Bölüm",
            'city' => $postProperty->country,
            'district' => $postProperty->district, 
            'post_address' => $postProperty->address,
            'deposit_value' => number_format(($post->start_price / 100) * $bank->deposit, 0, '.', '.'),
            'propturk_deposit_value' => number_format($post->deposit_ratio, 0, '.', '.'), //değiştirildi.

            'post_price' => number_format(($post->start_price), 0, '.', '.'),
            'user_name' => $user->name.' '.$user->surname,
            'user_identity_number' => $user->identity_number,

            'user_phone_number' => $user->phone_number,
            'user_email' => $user->email,
            'user_address' => $user->address,

            'company_name' => $user->company_name,
            'company_tax_office' => $user->company_tax_office,
            'company_tax_id' => $user->company_tax_id,
        ];
        
        $contractArray = [];

        $notificationLogType = 'mail';
        $notificationLogName = 'Mail - Kullanıcı ihale katılım talebi bildirimi'; //TenderUserPermissionMail
        $mailNotificationLog = NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, NULL);

        foreach ($post->contracts as $contractId) {

            $contract = Document::where('id', $contractId)->first();

            $contract->contract_description = Str::replace("{{ihaleKodu}}", $dataBank['post_code'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{ihaleKonumBilgileri}}", $dataBank['deed_infos'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{ihaleAcikAdresi}}", $dataBank['post_address'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{bankaDepozito}}", $dataBank['deposit_value'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriAdi}}", $dataBank['user_name'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriTcKimlikNo}}", $dataBank['user_identity_number'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriTelefonNumarasi}}", $dataBank['user_phone_number'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriEmail}}", $dataBank['user_email'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriAdresi}}", $dataBank['user_address'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{tasinmazBaslangicFiyati}}", $dataBank['post_price'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{propturkDepozito}}", $dataBank['propturk_deposit_value'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{ihaleIlBilgisi}}", $dataBank['city'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{ihaleIlceBilgisi}}", $dataBank['district'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriSirketUnvani}}", $dataBank['company_name'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriSirketVergiDairesi}}", $dataBank['company_tax_office'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{musteriSirketVergiNo}}", $dataBank['company_tax_id'], $contract->contract_description);
            $contract->contract_description = Str::replace("{{bugunTarih}}", now()->format('d/m/Y'), $contract->contract_description);
            $contractHtmlData = '
                <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                <head>
                    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                    <meta name="color-scheme" content="light">
                    <meta name="supported-color-schemes" content="light">
                    <style>
                        body { font-family: DejaVu Sans, sans-serif; }
                    </style>
                </head>
                <body>
                    '.$contract->contract_description.'
                </body>
            ';

            $contractPdfEncodeData = base64_encode(PDF::loadHTML($contractHtmlData)->setPaper('A4', 'portrait')->output());

            $filePath = 'storage/mail_file_archive/'.$post->id.'/'.$mailNotificationLog->id.'/'.$user->id;
            File::makeDirectory($filePath, 0777, true, true);
            $fileNameWithPath = $filePath.'/'.$user->name.'-'.$user->surname.'-'.str_replace(' ', '-', $contract->contract_name).'-'.rand(1, 100).'.pdf';
            $pdfFile = PDF::loadHTML($contractHtmlData)->setPaper('A4', 'portrait')->setWarnings(false)->save($fileNameWithPath);
            
            $archiveFile = new ArchiveFile([
                'file_name' => $fileNameWithPath,
                'size' => 1,
                'notification_log_id' => $mailNotificationLog->id,
                'post_id' => $post->id,
                'user_id' => $user->id
            ]);
            $archiveFile->save();

            array_push($contractArray, [
                'contractPdfHtmlData' => $contractPdfEncodeData,
                'contractName' => $contract->contract_name
            ]);
        }

        
        Mail::to($user->email)->queue(
            new TenderUserPermissionMail($user, $post, $contractArray, $bank)
        );

        $notificationLogType = 'sms';
        $notificationLogName = 'SMS - Kullanıcı ihale katılım talebi bildirimi'; //TenderUserPermissionSMS
        $notificationLogDesc = str_replace('%20', ' ', TenderUserPermissionSMS($user, $post));
        NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);

        sendSms($user, TenderUserPermissionSMS($user, $post));
        
    }

    
    public static function tenderWinnerMail($post) {
        
        $user = User::findOrFail($post->winner_id);

        $notificationLogType = 'mail';
        $notificationLogName = 'Mail - Kullanıcı ihale sonucu kazandı bildirimi'; //TenderWinnerMail
        NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, NULL);

        Mail::to($user->email)->queue(
            new TenderWinnerMail($user, $post)
        );

        $notificationLogType = 'sms';
        $notificationLogName = 'SMS - Kullanıcı ihale sonucu kazandı bildirimi'; //TenderWinnerSMS
        $notificationLogDesc = str_replace('%20', ' ', TenderWinnerSMS($user, $post));
        NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, $notificationLogDesc);

        sendSms($user, TenderWinnerSMS($user, $post));

        Log::channel('İlan')->info('İHALE SONUÇ - KAZANAN~'.'ID: '.$user->id.' E-mail: '.$user->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleyi kazanmıştır.');

    }

    public static function tenderLoserMail($post) {
        $loserUsers = $post->users->where('id', '!=', $post->winner_id);
        foreach($loserUsers as $loserUser) {
            $notificationLogType = 'mail';
            $notificationLogName = 'Mail - Kullanıcı ihale sonucu kaybetti bildirimi'; //TenderLoserMail
            NotificationLog::createNotificationLog($post, $loserUser, $notificationLogType, $notificationLogName, NULL);

            Mail::to($loserUser->email)->queue(
                new TenderLoserMail($loserUser, $post)
            );

            $notificationLogType = 'sms';                    
            $notificationLogName = 'SMS - Kullanıcı ihale sonucu kaybetti bildirimi'; //TenderLoserSMS
            $notificationLogDesc = str_replace('%20', ' ', TenderLoserSMS($loserUser, $post));
            NotificationLog::createNotificationLog($post, $loserUser, $notificationLogType, $notificationLogName, $notificationLogDesc);

            sendSms($loserUser, TenderLoserSMS($loserUser, $post));

            Log::channel('İlan')->info('İHALE SONUÇ - KAYBEDEN~'.'ID: '.$loserUser->id.' E-mail: '.$loserUser->email.' -- '.$post->tender_code.' ilan kodlu '.$post->title.' başlıklı ihaleyi kaybetmiştir.');

        }
    }

    public function higherOfferMail($user, $post) {

        //$oldOfferUser = $post->users->where('id', '!=', $user->id);
        $oldOfferUsers = $post->offers()->orderBy('created_at', 'desc')->take(2)->get();

        if($oldOfferUsers->count() >= 2 && $oldOfferUsers->first()->user_id != $oldOfferUsers->last()->user_id) {
            $notificationLogType = 'mail';    
            $notificationLogName = 'Mail - İhale daha yüksek teklif hatırlatma'; //HigherOfferMail
            NotificationLog::createNotificationLog($post, $user, $notificationLogType, $notificationLogName, NULL);

            Mail::to($oldOfferUsers->last()->user->email)->queue(
                new HigherOfferMail($oldOfferUsers->last()->user, $post)
            );

            $notificationLogType = 'sms';    
            $notificationLogName = 'SMS - İhale daha yüksek teklif hatırlatma'; //HigherOfferSMS
            $notificationLogDesc = str_replace('%20', ' ', HigherOfferSMS($oldOfferUsers->last()->user, $post));
            NotificationLog::createNotificationLog($post, $oldOfferUsers->last()->user, $notificationLogType, $notificationLogName, $notificationLogDesc);


            sendSms($oldOfferUsers->last()->user, HigherOfferSMS($oldOfferUsers->last()->user, $post));
        }
    }


    public function showResult() {
        return view('mail.pdf-templates.finished-tender-report');
    }
}