<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBankRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string',
            'code' => 'required|string',
            'branch' => 'nullable|string',
            'branch_no' => 'nullable|string',
            'account_no' => 'nullable',
            'iban' => 'nullable|string',
            'deposit' => 'nullable|integer',
            'is_active' => 'integer',
            'completed_tenders_is_visible' => 'integer',
            'bank_sales_contract_name' => 'nullable',
            'bank_sales_contract_description' => 'nullable',
        ];
    }
}
