<?php

namespace App\Mail;

use App\Models\Post;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ActivationUserOfferRequestMail extends Mailable
{
    use Queueable, SerializesModels;
   
    public $user;
    public $post;

    public function __construct(User $user, Post $post)
    {
        $this->user = $user;
        $this->post = $post;
    }

    public function build()
    {
        $subject = $this->post->code.' Kodlu Taşınmaza Ait Teklif Hatırlatması';
        return $this
        ->markdown('mail.activation-user-offer-request-mail')
        ->from('bilgi@markest.com.tr')
        ->subject($subject);  
    }
}
