<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bank extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name', 'code', 'branch', 'branch_no', 'account_no', 'iban', 'deposit', 'is_active',
        'completed_tenders_is_visible',
        
    ];

    public function posts() {
        return $this->hasMany(Post::class);
    }

    public function documents() {
        return $this->hasMany(Document::class);
    }
    
    public static function boot()
    {
        parent::boot();

        static::deleting(function (Bank $bank) {
            $bank->posts()->delete();
        });
    }
    


    
}
