<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Property extends Model
{
    use HasFactory, SoftDeletes, Sluggable;

    protected $fillable = [
        'property_type', 'house_type', 'gross_m2', 'net_m2', 'building_age', 'heating_type', 'using_status',
        'room_count', 'floor', 'total_floor', 'bath_count', 'is_balcony', 'is_furnished', 'is_site',
        'is_creditable', 'dues', 'side', 'inside_properties', 'outside_properties', 'country', 'district', 
        'neighborhood', 'address', 'parsel_request_url', 'longitude', 'langitude', 'land_type', 'peer', 
        'clearence', 'land_state', 'infrastructure', 'general_properties', 'workplace_type', 'neighborhood_id', 'slug',
        'city_block_no', 'parcel_no', 'independent_section_no', 'general_properties_land', 'zoning_status_exp', 'floor_no', 'block_no'
    ];

    
    public function post() {
        return $this->morphOne(Post::class, 'postable');
    }

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'slug'
            ]
        ];
    }
    
    public function getRouteKeyName(): string
    {

        return $this->getSlugKeyName();
    }

    public function scopePropertyWithRelations(Builder $query) {
        return $query->with('post', 'post.bank', 'post.bank.documents')->latest()->get();
    }

    public static function boot()
    {
        parent::boot();

        static::deleting(function (Property $property) {
            $property->post->offers()->delete();
            $property->post()->delete();
        });
    }
}
