<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Http\ViewComposers\PropertyComposer;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{

    public function boot()
    {
        view()->composer(['admin.properties.index', 'users.properties.index'], PropertyComposer::class);
        
        Validator::extend('offer_check', function($attributes, $value, $parameters){
            if($parameters[2])
            {
                return $value == $parameters[0];
            }
            else
            {
                return $value == $parameters[0] + $parameters[1];
            }
        });

        Validator::extend('recaptcha', 'App\\Validators\\ReCaptcha@validate');
    }

    public function register()
    {
        //
    }
}
