<?php

namespace App\Providers;

use App\Models\Post;
use App\Models\Property;
use App\Models\User;
use App\Policies\PropertyPolicy;
use App\Policies\UserPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Property::class => PropertyPolicy::class,
        User::class => UserPolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        
        $this->registerPolicies();
        Gate::define('show-logs', function(User $user) {
            if($user->is_admin == 1) {
                return true;
            }
            return false;
        });
        /*
        Gate::define('show-tender', function ( Post $post, User $user) {
            dd($post);
            if($post->tender_status == 1) {
                return true;
            }
            return false;
            
        });*/
        //
    }
}
