<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePropertiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();

            $table->integer('property_type');
            $table->integer('house_type')->nullable();
            $table->integer('gross_m2')->nullable();
            $table->integer('net_m2')->nullable();
            $table->integer('building_age')->nullable();
            $table->integer('heating_type')->nullable();
            $table->integer('using_status')->nullable();
            $table->integer('room_count')->nullable();
            $table->integer('floor')->nullable();
            $table->integer('total_floor')->nullable();
            $table->integer('bath_count')->nullable();
            $table->boolean('is_balcony')->default(false);
            $table->boolean('is_furnished')->default(false);
            $table->boolean('is_site')->default(false);
            $table->boolean('is_creditable')->default(false);
            $table->integer('dues')->nullable();
            $table->longText('side')->nullable();
            $table->longText('inside_properties')->nullable();
            $table->longText('outside_properties')->nullable();
            $table->longText('floor_no')->nullable();
            $table->longText('block_no')->nullable();
            $table->longText('zoning_status_exp')->nullable();

            $table->integer('land_type')->nullable();
            $table->integer('peer')->nullable();
            $table->integer('clearence')->nullable();
            $table->integer('land_state')->nullable();
            $table->longText('infrastructure')->nullable();
            $table->longText('general_properties')->nullable();
            $table->longText('general_properties_land')->nullable();

            $table->integer('workplace_type')->nullable();
            

            $table->longText('country')->nullable();
            $table->longText('district')->nullable();
            $table->longText('neighborhood')->nullable();
            $table->integer('neighborhood_id')->nullable();
            $table->longText('address')->nullable();
            $table->longText('parsel_request_url')->nullable();
            $table->double('longitude')->nullable();
            $table->double('langitude')->nullable();
            $table->longText('city_block_no')->nullable();
            $table->longText('parcel_no')->nullable();
            $table->longText('independent_section_no')->nullable();

            $table->longText('slug')->nullable();;

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('properties');
    }
}
