<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->longText('code');
            $table->longText('title');
            $table->longText('desc')->nullable();
            $table->boolean('is_opportunity')->default(false);
            $table->unsignedBigInteger('duration');
            $table->integer('start_price'); //Malın başlangıç değeri
            $table->integer('offer_step');
            $table->integer('winner_id')->nullable();
            $table->boolean('is_warrant')->default(false);
            $table->integer('entry_price');  //kullanıcının ihaleye girebilmesi için, start_price / bank tablosunda bankanın deposit oranı kadar olacak. Bankaya ödenecek
            $table->integer('current_price'); //kayıt edildiği zaman start_price eşit olacak.
            $table->boolean('is_fast_buy')->default(false);
            $table->integer('fast_buy_price')->nullable();
            $table->integer('deposit_ratio'); //propturk hizmete bedeli
            $table->integer('tender_status')->default(0);
            $table->integer('tender_code');
            $table->dateTime('publish_time')->nullable();
            $table->dateTime('end_time')->nullable();
            $table->dateTime('first_offer_time')->nullable();
            $table->longText('images_folder')->nullable();
            $table->longText('mailed_users')->nullable();

            $table->longText('contracts')->nullable();

            $table->unsignedBigInteger('bank_id')->index();
            $table->foreign('bank_id')->references('id')->on('banks')->onDelete('cascade');

            $table->string('short_link_code');
            $table->morphs('postable');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
}