<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\User;
use Illuminate\Database\Seeder;

class PostUserSeeder extends Seeder
{

    public function run()
    {
        $postCount = Post::all()->count();

        User::all()->each(function(User $user) use($postCount) {
            if($user->is_admin){
                return true;
            }
            $take = random_int(0, $postCount);
            $posts = Post::inRandomOrder()->take($take)->get()->pluck('id');
            $user->posts()->sync($posts);
        });

    }
}
