@extends('admin.layout.layout')

@section('title', 'Admin')

@section('styles')
    @parent
@stop

@section('content')
<section>
    <headerclass="border-bottom my-4">
        <h3 class="text-primary font-weight-light">Öne Çıkan Hizmetler</h3>
    </header>

    <div class="row justify-content-center py-3">

        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-success text-white py-lg-4 px-lg-3" href="{{ route('admin.properties.index') }}" title="Tüm İlanlar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="fas fa-home"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">İlanlar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-secondary text-white py-lg-4 px-lg-3" href="{{ route('admin.users.index') }}" title="Kayıtlı Kullanıcılar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="fa fa-users" aria-hidden="true"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Kullanıcılar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-danger text-white py-lg-4 px-lg-3" href="{{ route('admin.banks.index') }}" title="Kayıtlı Bankalar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="far fa-list-alt"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Bankalar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-warning text-white py-lg-4 px-lg-3" href="{{ route('admin.documents.index') }}" title="Evraklar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="far fa-list-alt"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Evraklar</h4>
            </a>
        </div>
        @if(Auth::user()->is_admin == 1)
            <div class="col-12 col-md-3 pb-4">
                <a class="btn btn-block btn-info text-white py-lg-4 px-lg-3" href="{{ route('admin.logs') }}" title="Log Kayıtları" style="height: 100%">
                    <div class="d-flex justify-content-between">
                        <span class="h1"><i class="fa fa-book" aria-hidden="true"></i></span>
                        <i class="fas fa-chevron-right align-self-center"></i>
                    </div>
                    <h4 class="mt-3 text-left h5">Log Kayıtları</h4>
                </a>
            </div>
        @endif
    </div>
</section>

<section class="pb-5">
    <header class="border-bottom border-primary">
        <h2 class="text-primary h5 font-weight-light"><i class="fas fa-chart-line"></i> En çok ziyaret edilen 5 ilan</h2>
    </header>
    <div class="row py-3">
        @foreach ($posts as $post)
            <article class="col-lg-4 col-sm-6 px-3 mb-5">
                <div class="d-flex align-content-between flex-wrap rounded overflow-hidden bg-white border-bottom border-left border-right pb-3" style="height: 100%;">
                    <div class="w-100">
                        <div class="position-relative">
                            <img class="d-block w-100 img-fluid" 
                            @if (isset(Storage::allFiles($post->images_folder)[0]))
                                src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}"
                            @endif style="max-height: 275px;min-height: 275px;object-fit: cover;"/>
                            <div class="position-absolute imobi_info p-2" style="cursor: pointer">
                                <span class="badge badge-secondary shadow-sm" style="font-size: 17px;background-color:#1e1e1e" data-toggle="tooltip" title="Görüldü"><i class="far fa-eye mr-1"></i>{{ $post->posts_views_count }}</span>           
                            </div>
                        </div>
                        <div class="w-100 px-3 pt-3">
                            <div>
                                <p class="mb-1"><b class='text-primary' style="font-size: 18px;">{{ number_format($post->current_price, 0, '.', '.') }} ₺</b></p>
                            </div>
                            <div class="d-flex justify-content-between">
                                
                                <p class="mb-2 text-muted">İlan Kodu :<span style="color: black">{{ $post->code }}</span></p>
                                <p class="mb-2 text-muted">İhale Kodu :<span style="color: black">{{ $post->tender_code }}</span></p>
                                
                            </div>
                            <div>
                                <h3 class="h6 text-success mb-3">{{ $post->title }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
        @endforeach
    </div>
</section>

{{-- <section class="pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light">Property Summary</h3>
    </header>
    <div class="row">
        <!--Transação-->
        <div class="col-sm-6 col-lg-3 mb-4">
            <article class="d-flex align-items-end flex-column w-100 bg-white px-2 px-xl-3 rounded shadow-sm border-bottom border-primary pb-3"  style="height: 100%;">
                <h4 class="text-primary font-weight-light py-2 border-bottom border-primary h6 w-100">Transaction type</h4>
                <div class="d-block w-100">
                    <a class="w-100 d-flex justify-content-between text-primary text_small" href="#" title="">
                        <span>Rent</span>
                        <span class="ml-auto">003</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-success text_small" href="#" title="">
                        <span>Sale</span>
                        <span class="ml-auto">006</span>
                    </a>
                </div>

                <div class="w-100 mt-auto pt-3">
                    <div class="progress" style="height: 10px;">
                        <div class="progress-bar bg-primary" role="progressbar" data-toggle="tooltip" data-original-title="003 - Property to Rent" style="width: 33.333333333333%" aria-valuenow="33.333333333333" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-success" role="progressbar" data-toggle="tooltip" data-original-title="006 - Property to Sale" style="width: 66.666666666667%" aria-valuenow="66.666666666667" aria-valuemin="0" aria-valuemax="9"></div>
                    </div>
                </div>

            </article>
        </div>


        <!--Finalidade-->
        <div class="col-sm-6 col-lg-3 mb-4">
            <article class="d-flex align-items-end flex-column w-100 bg-white px-2 px-xl-3 rounded shadow-sm border-bottom border-primary pb-3"  style="height: 100%;">
                <h4 class="text-primary font-weight-light py-2 border-bottom border-primary h6 w-100">Finality</h4>
                <div class="d-block w-100">
                    <a class="w-100 d-flex justify-content-between text-primary text_small" href="#" title="">
                        <span>Commercial</span>
                        <span class="ml-auto">002</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-success text_small" href="#" title="">
                        <span>Residential</span>
                        <span class="ml-auto">007</span>
                    </a>
                </div>


                <div class="w-100 mt-auto pt-3">
                    <div class="progress" style="height: 10px;">
                        <div class="progress-bar bg-primary" role="progressbar" data-toggle="tooltip" data-original-title="002 - Commercial" style="width: 22.222222222222%" aria-valuenow="22.222222222222" aria-valuemin="0" aria-valuemax="9"></div>

                        <div class="progress-bar bg-success" role="progressbar" data-toggle="tooltip" data-original-title="007 - Residential" style="width: 77.777777777778%" aria-valuenow="77.777777777778" aria-valuemin="0" aria-valuemax="9"></div>
                    </div>
                </div>
            </article>
        </div>


        <!--Tipo-->
        <div class="col-sm-6 col-lg-3 mb-4">
            <article class="d-flex align-items-end flex-column w-100 bg-white px-2 px-xl-3 rounded shadow-sm border-bottom border-primary pb-3"  style="height: 100%;">
                <h3 class="text-primary font-weight-light py-2 border-bottom border-primary h6 w-100">Property Type</h3>

                <div class="d-block w-100">
                    <a class="w-100 d-flex justify-content-between text-primary text_small" href="#" title="">
                        <span>Apartment</span>
                        <span class="ml-auto">002</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-success text_small" href="#" title="">
                        <span>Area</span>
                        <span class="ml-auto">001</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-warning text_small" href="#" title="">
                        <span>House</span>
                        <span class="ml-auto">004</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-info text_small" href="#" title="">
                        <span>Room</span>
                        <span class="ml-auto">001</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-secondary text_small" href="#" title="">
                        <span>Ground</span>
                        <span class="ml-auto">001</span>
                    </a>
                </div>


                <div class="w-100 mt-auto pt-3">
                    <div class="progress" style="height: 10px;">
                        <div class="progress-bar bg-primary" role="progressbar" data-toggle="tooltip" data-original-title="002 - Apartment" style="width: 22.222222222222%" aria-valuenow="22.222222222222" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-success" role="progressbar" data-toggle="tooltip" data-original-title="001 - Area" style="width: 11.111111111111%" aria-valuenow="11.111111111111" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-warning" role="progressbar" data-toggle="tooltip" data-original-title="004 - House" style="width: 44.444444444444%" aria-valuenow="44.444444444444" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-info" role="progressbar" data-toggle="tooltip" data-original-title="001 - Room" style="width: 11.111111111111%" aria-valuenow="11.111111111111" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-secondary" role="progressbar" data-toggle="tooltip" data-original-title="001 - Ground" style="width: 11.111111111111%" aria-valuenow="11.111111111111" aria-valuemin="0" aria-valuemax="9"></div>
                    </div>
                </div>
            </article>
        </div>


        <!--Cidade-->
        <div class="col-sm-6 col-lg-3 mb-4">
            <article class="d-flex align-items-end flex-column w-100 bg-white px-2 px-xl-3 rounded shadow-sm border-bottom border-primary pb-3"  style="height: 100%;">
                <h3 class="text-primary font-weight-light py-2 border-bottom border-primary h6 w-100">City</h3>
                <div class="d-block w-100">
                    <a class="w-100 d-flex justify-content-between text-primary text_small" href="#" title="">
                        <span>Florianópolis</span>
                        <span class="ml-auto">005</span>
                    </a>
                    <a class="w-100 d-flex justify-content-between text-success text_small" href="#" title="">
                        <span>Sorocaba</span>
                        <span class="ml-auto">004</span>
                    </a>
                </div>
                <div class="w-100 mt-auto pt-3">
                    <div class="progress" style="height: 10px;">
                        <div class="progress-bar bg-primary" role="progressbar" data-toggle="tooltip" data-original-title="005 - Florianópolis" style="width: 55.555555555556%" aria-valuenow="55.555555555556" aria-valuemin="0" aria-valuemax="9"></div>
                        <div class="progress-bar bg-success" role="progressbar" data-toggle="tooltip" data-original-title="004 - Sorocaba" style="width: 44.444444444444%" aria-valuenow="44.444444444444" aria-valuemin="0" aria-valuemax="9"></div>
                    </div>
                </div>
            </article>
        </div>
    </div>

    <div class="py-3 row">
        <section class="col-lg-6 mb-4">
            <div class="bg-white rounded shadow-sm p-3 border-bottom border-primary" style="height: 100%;">
                <header class="border-bottom border-primary">
                    <h4 class="text-primary h5 font-weight-light"><i class="fas fa-home"></i> Your recent properties</h4>
                </header>
                <div class="pt-3">
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3 d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                        <span class="badge badge-success" data-toggle="tooltip" title="Observation">Detach</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                        <span class="badge badge-success" data-toggle="tooltip" title="Observation">Promotion</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>

                </div>
            </div>
        </section>

        <section class="col-lg-6 mb-4">
            <div class="bg-white rounded shadow-sm p-3 border-bottom border-primary" style="height: 100%;">
                <header class="border-bottom border-primary">
                    <h2 class="text-primary h5 font-weight-light"><i class="fas fa-chart-line"></i> Your most viewed properties</h2>
                </header>
                <div class="pt-3">
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                        <span class="badge badge-success" data-toggle="tooltip" title="Observation">Detach</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                        <span class="badge badge-success" data-toggle="tooltip" title="Observation">Promotion</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>
                    <article class="mb-2 pb-2 border-bottom">
                        <a title=''  href='property-single.html' class='btn btn-outline-light border-0 px-0 overflow-hidden'>
                            <div class="row no-gutters">
                                <div class="col-sm-4">
                                    <img class="d-block w-100" />
                                </div>
                                <div class='col-sm-8 text-left px-2 px-sm-3  d-flex align-content-between flex-wrap py-3 py-sm-0'>
                                    <h5 class="h6 text-info font-weight-light w-100">Beautiful house with large living room</h5>
                                    <p class="mb-0 text_small text-muted d-inline-block w-100"><i class="fas fa-street-view"></i> House in Lopes De Oliveira Sorocaba/SP</p>

                                    <span class="w-100 d-block">
                                        <span class="badge badge-secondary" data-toggle="tooltip" title='Views'><i class="far fa-eye mr-1"></i> 0009</span>
                                        <span class="badge badge-primary" data-toggle="tooltip" title='Finality'>For Sale</span>
                                    </span>                                                
                                </div>
                            </div>
                        </a>
                    </article>

                </div>
            </div>
        </section>

    </div>
</section> --}}
@stop

@section('scripts')
    @parent
    <script>
        
    </script>
@endsection