@extends('admin.layout.layout')

@section('title', 'İlan Düzenle')

@section('styles')
    @parent
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .form-control:focus{
            box-shadow: 0 0 0 0rem rgb(0 0 0 / 0%);
        }
        .form-group-border{
            border: 1px solid #e9dbdb;
            padding-bottom: 15px;
        }
        .label-under{
            text-decoration: underline;
            text-decoration-color: #f4eded;
            padding: 5px;
        }
        .ui-list-div{
            display: flex;flex-direction: row;flex-wrap: wrap;padding: 15px;
        }

        input[type="file"] {
            display: block;
        }
        .imageThumb {
            max-height: 175px;
            border:1px solid #ddd;
            padding: 1px;
            cursor: pointer;
            width: 100%;
            object-fit: cover;
        }
        .pip {
            display: inline-block;
            margin: 10px 10px 0 0;
        }
        .remove {
            display: block;
            background: #444;
            border: 1px solid #ddd;
            color: white;
            text-align: center;
            cursor: pointer;
        }
        .remove:hover {
            background: white;
            color: black;
        }
        #url_langitude {
            pointer-events: none;
        }
        #url_longitude{
            pointer-events: none;
        }
        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:7px;
        }
        
        .text-currency{
            padding:10px 20px;
            border:solid 1px #ccc;
            border-radius:5px;
        }
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
    </style>
@stop

@section('content')
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.properties.index') }}">İlanlar</a></li>
        <li class="breadcrumb-item active" aria-current="page">İlan Düzenle</li>
    </ol>
</nav>
{{-- {{ dd($property) }} --}}
<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="fas fa-sign"></i>İlan Düzenle</h3>
    </header>
    <div class="d-flex" style="justify-content: flex-end;">
        <a class="btn btn-danger" href="{{ route('admin.imagePage', ['slug' => $property->slug]) }}">İlan Resimleri</a>
    </div>
    <div class="py-3">
        <div class="wizard-content bg-white rounded border shadow-sm py-3 py-md-4 py-lg-5 px-3 px-md-4 px-lg-5">
            <form id="wizard_form" action="{{ route('admin.properties.update', ['property' => $property->slug]) }}" class="tab-wizard wizard-circle wizard clearfix text-muted" method="post" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <h6>Temel</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-laptop-house"></i> Temel:</h4>
                    </header>
                    <div class="py-3">
                        <div class="form-row">
                            <div class="col-md-6 col-lg-7">
                                <div class="form-group">
                                    <label for="property_code">İlan Kodu:</label>
                                    <input class="form-control" value="{{ $property->post->code }}" type="text" name="post[code]" id="property_code" placeholder="İlan Kodu" required>
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="property_bank">Banka:</label>
                                        <select class="form-control" name="post[bank_id]" id="bank_select">
                                            @foreach ($banks as $bank)
                                                <option value="{{ $bank->id }}" {{ $property->post->bank_id == $bank->id ? 'selected' : ''}}>
                                                    {{ $bank->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label for="deposit_ratio">Teminat Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="{{ $property->post->bank->deposit }}" type="text" id="deposit_ratio" placeholder="Teminat Oranı" required>
                                        </div>                          
                                    </div>
                                </div>
                                
                                <div class="form-group d-flex">
                                    <div class="col-md-12 pl-0">
                                        <label for="deposit_ratio">İhaleye Dahil Edilecek Evraklar:</label>
                                        <div id="contact-container">
                                            @foreach ($property->post->bank->documents as $document)
                                                <div class="col-auto">
                                                    <input class="contracts" type="checkbox" value="{{ $document->id }}" name="post[contracts][]"
                                                    @if ($property->post->contracts != null)
                                                        @if (in_array($document->id, $property->post->contracts))
                                                            checked
                                                        @endif   
                                                    @endif
                                                    >
                                                    <span style="margin-right: 15px;">{{ $document->contract_name }}</span>
                                                </div>                                                
                                            @endforeach
                                            @foreach ($propturkContracts as $document)
                                                <div class="col-auto">
                                                    <input class="contracts" type="checkbox" value="{{ $document->id }}" name="post[contracts][]"
                                                    @if ($property->post->contracts != null)
                                                        @if (in_array($document->id, $property->post->contracts))
                                                            checked
                                                        @endif   
                                                    @endif
                                                    >
                                                    <span style="margin-right: 15px;">{{ $document->contract_name }}</span>
                                                </div>                                                
                                            @endforeach
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="property_type">Emlak Tipi</label>
                                    <div>
                                        <input class="properties-type-input" type="radio" value="0" 
                                        @if ($property->property_type == 0)
                                            checked
                                        @endif
                                        disabled
                                        name="properties[property_type]">
                                        <span style="margin-right: 15px;">Konut</span>
                                        <input class="properties-type-input" type="radio" value="1"
                                        @if ($property->property_type == 1)
                                            checked
                                        @endif
                                        disabled
                                        name="properties[property_type]">
                                        <span style="margin-right: 15px;">İş Yeri</span>
                                        <input class="properties-type-input" type="radio" value="2" 
                                        @if ($property->property_type == 2)
                                            checked
                                        @endif
                                        disabled
                                        name="properties[property_type]">
                                        <span>Arsa</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="property_title">İlan Başlığı:</label>
                                    <input class="form-control"  value="{{ $property->post->title }}" type="text" name="post[title]" id="property_title"  placeholder="İlan Başlığı" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-12 col-md-7">
                                <div class="form-group">
                                    <label for="property_desc">Açıklama:</label>                                      
                                    <textarea class="form-control summernote border" name="post[desc]" id="property_desc" rows="5">{{ $property->post->desc }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6 col-lg-7">
                                <div class="form-group">
                                    <label for="is_opportunity">Fırsat Butonu:</label>                                      
                                    <input type="checkbox" name="post[is_opportunity]" value="0">
                                </div>
                                <div class="form-group">
                                    <label for="duration">İlan Süresi:</label>
                                    <div class="d-flex">
                                        <div class="w-100">
                                            <label for="duration_day" style="font-size: 12px;text-decoration: underline;">Gün</label>
                                            <input class="form-control" value="{{ $postDay }}" type="number" name="post[duration_day]" id="duration_day" min="0" placeholder="İlan Süresi(Gün)" required>
                                        </div>
                                        <div class="w-100" style="margin-left: 30px;">
                                            <label for="duration_hour" style="font-size: 12px;text-decoration: underline;">Saat</label>
                                            <input class="form-control" value="{{ $postHour }}" type="number" name="post[duration_hour]" id="duration_hour" min="0" max="23" placeholder="İlan Süresi(Saat)" required>
                                        </div>
                                    </div>                                   
                                </div>
                                <div class="form-group">
                                    <label for="start_price">Başlangıç Bedeli:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="{{ $property->post->start_price }}" type="text" name="post[start_price]" id="start_price" placeholder="Başlangıç Bedeli" required>
                                    </div>                                  
                                    {{-- <input class="form-control formCurrency" value="{{ $property->post->start_price }}" type="number" name="post[start_price]" id="start_price" placeholder="Başlangıç Bedeli" required> --}}
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="offer_step">Teklif Adımı:</label>  
                                        <div class="currency-wrap">
                                            <span class="currency-code">&#x20BA;</span>
                                            <input class="form-control money text-currency" value="{{ $property->post->offer_step }}" type="text" name="post[offer_step]" id="offer_step" placeholder="Teklif Adımı" required>
                                        </div>                                     
                                        {{-- <input class="form-control formCurrency" value="{{ $property->post->offer_step }}" type="number" name="post[offer_step]" id="offer_step" placeholder="Teklif Adımı" required> --}}
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label for="offer_ratio">Teklif Adım Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="1" min="0" minlength="0.5" maxlength="100" step="0.5" type="number" id="offer_ratio" placeholder="Teminat Oranı">
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="form-group">
                                    <label for="is_warrant">Teminatı PropTürk Tutacak?:</label>                                      
                                    <select class="form-control" name="post[is_warrant]" id="is_warrant">
                                        <option
                                        value="0"
                                        @if ($property->post->is_warrant == 0)
                                            selected
                                        @endif>Hayır</option>
                                        <option  
                                        value="1"
                                        @if ($property->post->is_warrant == 1)
                                            
                                            selected
                                        @endif>Evet</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="entry_price">Banka İhale Teminat Bedeli:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="{{ $property->post->entry_price }}" type="text" name="post[entry_price]" id="entry_price" placeholder="İhale Katılım Bedeli" required>
                                    </div>                                     
                                    {{-- <input class="form-control formCurrency" value="{{ $property->post->entry_price }}" type="number" name="post[entry_price]" id="entry_price" placeholder="İhale Katılım Bedeli" required> --}}
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="entry_price">PropTürk İhale Katılım Bedeli:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">&#x20BA;</span>
                                            <input class="form-control money text-currency" value="{{ $property->post->deposit_ratio }}" type="text" name="post[deposit_ratio]" id="propturk_deposit" placeholder="İhale Katılım Bedeli" required>
                                        </div>                                         
                                    </div>
                                    <div class="col-md-6 pl-0">
                                        <label for="offer_ratio_propturk">Proptürk İhale Katılım Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="" min="0" minlength="0.5" maxlength="100" step="1" type="number" id="offer_ratio_propturk" placeholder=" Propturk Teminat Oranı">
                                        </div>
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label for="is_fast_buy">Hemen Al Açık?:</label>                                      
                                    <select class="form-control" name="post[is_fast_buy]" id="is_fast_buy">
                                        <option
                                        @if ($property->post->is_fast_buy == 0)
                                            selected
                                        @endif
                                        value="0"
                                        >Hayır</option>
                                        <option  
                                        @if ($property->post->is_fast_buy == 1)
                                            selected
                                        @endif value="1">Evet</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="fast_buy_price">Hemen Al Fiyatı:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="{{ $property->post->fast_buy_price }}" type="text" name="post[fast_buy_price]" id="fast_buy_price" placeholder="Hemen Al Fiyatı" disabled>
                                    </div>                                        
                                    {{-- <input class="form-control formCurrency" value="{{ $property->post->fast_buy_price }}" type="number" name="post[fast_buy_price]" id="fast_buy_price" placeholder="Hemen Al Fiyatı" disabled> --}}
                                </div>
                                {{-- <div class="form-group">
                                    <label for="deposit_ratio">Teminat Oranı:</label>                                      
                                    <input class="form-control" value="{{ $property->post->deposit_ratio }}" type="number" name="post[deposit_ratio]" id="deposit_ratio" placeholder="Teminat Oranı" required>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </section>

                <h6>Detay</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-tags"></i> Detay:</h4>
                    </header>
                    {{-- <div id="ajaxProperties"></div> --}}
                    @if ($property->property_type == 0)
                        @include('admin.properties.properties_edit.properties1')
                    @endif
                    @if ($property->property_type == 1)
                        @include('admin.properties.properties_edit.properties2')
                    @endif
                    @if ($property->property_type == 2)
                        @include('admin.properties.properties_edit.properties3')
                    @endif
                </section>

                <h6>Adres</h6>
                <section class="content_address">
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-street-view"></i> Adres:</h4>
                    </header>
                    <div class="form-row">
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="country">İl:</label>
                                <select class="js-select2-city" name="properties[country]">
                                    <option></option>
                                    @foreach ($cities as $city)
                                        <option
                                        @if ($property->city_id == $city->id)
                                            value="{{ $city->id }}"
                                            selected
                                        @endif
                                        value="{{ $city->id }}">{{ $city->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="district">İlçe:</label>
                                <select class="js-select2-district" name="properties[district]" id="property_district">
                                    @if(isset($districts))
                                        @foreach ($districts as $district)
                                            <option 
                                            @if ($neighborhood->district_id == $district->id)
                                                value="{{ $district->id }}"
                                                selected
                                            @endif
                                            value="{{ $district->id }}"
                                            >{{ $district->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="property_complement">Semt/Mahalle:</label>
                                <select class="js-select2-neighborhood" name="properties[neighborhood]" id="property_neighborhood">
                                    @if(isset($neighborhoods))
                                        @foreach ($neighborhoods as $item)
                                            <option 
                                            @if ($neighborhood->id == $item->id)
                                                value="{{ $item->id }}"
                                                selected
                                            @endif
                                            value="{{ $item->id }}"
                                            >{{ $item->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="city_block_no">Ada No</label>
                                <input type="text" class="form-control" value="{{ $property->city_block_no }}" name="properties[city_block_no]" id="city_block_no">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="parcel_no">Parsel No</label>
                                <input type="text" class="form-control" value="{{ $property->parcel_no }}" name="properties[parcel_no]" id="parcel_no">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="floor_no">Kat No</label>
                                <input type="text" class="form-control" value="{{ $property->floor_no }}" name="properties[floor_no]">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="block_no">Blok No</label>
                                <input type="text" class="form-control" value="{{ $property->block_no }}" name="properties[block_no]">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="independent_section_no">Bağımsız Bölüm No</label>
                                <input type="text" class="form-control" value="{{ $property->independent_section_no }}" name="properties[independent_section_no]" id="independent_section_no">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="city_block_no">Ada No</label>
                                <input type="text" class="form-control" value="{{ $property->city_block_no }}" name="properties[city_block_no]" id="city_block_no">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="parcel_no">Parsel No</label>
                                <input type="text" class="form-control" value="{{ $property->parcel_no }}" name="properties[parcel_no]" id="parcel_no">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="independent_section_no">Bağımsız Bölüm No</label>
                                <input type="text" class="form-control" value="{{ $property->independent_section_no }}" name="properties[independent_section_no]" id="independent_section_no">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="parsel_request_url">Parsel Sorgu Url</label>
                                <input type="text" class="form-control" name="properties[parsel_request_url]" value="{{ $property->parsel_request_url }}" id="parsel_request_url">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="langitude">Enlem</label>
                                <input type="text" class="form-control" value="{{ $property->langitude }}" name="properties[langitude]" id="url_langitude">
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="longitude">Boylam</label>
                                <input type="text" class="form-control" value="{{ $property->longitude }}" name="properties[longitude]" id="url_longitude">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-8">
                            <div id="map" style="width: 100%; height: 500px;"></div>
                        </div>
                    </div>
                </section>
                
                {{-- <h6>Fotoğraf</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="far fa-images"></i> Gallery:</h4>
                    </header>
                    <div class="pb-3">
                        <div class="field" text-align="left">
                            <h3>İlan Resimlerini Yükleyiniz</h3>
                            <input type="file" id="files" name="images_folder[]" multiple />
                            
                            
                            @foreach(Storage::allFiles($property->post->images_folder) as $image)  
                                <span class=pip>
                                    <img class="imageThumb" src="{{ Storage::url($image) }}" title="{{ $image }}"/>
                                    <br/>
                                    <span class="remove">Resmi Sil</span>
                                </span>
                            @endforeach
                            
                        </div>
                    </div>
                </section> --}}

                <h6>Yayın</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-sign"></i> Yayın:</h4>
                    </header>
                    <div class="py-3">
                        <div class="text-center pt-5">
                            <button type="submit" class="btn btn-lg btn-primary slow_3s position-relative px-4 mb-1">
                                Kaydet
                            </button>
                        </div>
                    </div>
                </section>
            </form>
        </div>
    </div>

</section>
@stop

@section('scripts')
    @parent
    {{-- <script src="{{ asset('assets/plugins/dropzone/dropzone.min.js') }}"></script> --}}
    <script src="{{ asset('assets/plugins/jquery/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/step_wizard/jquery.steps.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/step_wizard/wizard_step_init.js') }}"></script>
    {{-- <script src="{{ asset('assets/_js/dashboard-form.js') }}"></script> --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
    <!-- Datepicker -->
    <script src="{{ asset('assets/plugins/datepicker/datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datepicker/datepicker.en-US.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    @if(isset($property->longitude))
        <script>
            $(document).ready(function () {

                var lantg = {!! $property->longitude !!};
                var lontg = {!! $property->langitude !!};

                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            });
        </script>
    @endif
    <script>
        $(document).ready(function () {

            var steps = $('.steps').find('li.disabled');
            steps.attr('class', 'done');

            $('#parsel_request_url').change(function(){
                console.log('sa');
                var url = $('#parsel_request_url').val();
                url_lang = url.split('/')[5];
                $('#url_langitude').val(url_lang);
                url_long = url.split('/')[6];
                $('#url_longitude').val(url_long);

                var lantg = url_long;
                var lontg = url_lang;
            
                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            });
            // $("#parsel_request_url").bind("paste", function(e){
            //     var url = $('#parsel_request_url').val();
            //     url_lang = url.split('/')[5];
            //     $('#url_langitude').val(url_lang);
            //     url_long = url.split('/')[6];
            //     $('#url_longitude').val(url_long);
            // });
        });
    </script>
    <script>
        // is_fast_buy
        $(document).ready(function () {
            
            var s = $('#is_fast_buy').val();
            if (s == 1) {
                    $('#fast_buy_price').prop( "disabled", false );
                }
            if (s == 0) {
                $('#fast_buy_price').prop( "disabled", true );
            }
            $('#is_fast_buy').change(function() {
                var c = $(this).val();
                console.log(c);
                if (c == 1) {
                    $('#fast_buy_price').prop( "disabled", false );
                }
                if (c == 0) {
                    $('#fast_buy_price').prop( "disabled", true );
                }
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.js-select2-city').select2({
                dropdownAutoWidth : true,
                width: 'auto',
                placeholder: "Lütfen Şehir Seçiniz",
            });

            // var $a = $('.js-select2-distirct');
            // .select2({
            //     dropdownAutoWidth : true,
            //     width: 'auto'
            // });

            $('.js-select2-city').on('select2:select', function (e) {
                var data = e.params.data;
                console.log(data.id);

                var cityId = data.id;
                $.ajax({
                    type:'GET',
                    url: "{!! route('address.getDistricts', '') !!}" + "/" + cityId,
                    success:function(data){
                        $('.js-select2-district').empty().select2({
                            dropdownAutoWidth : true,
                            width: 'auto',
                            placeholder: "Lütfen İlçe Seçiniz",
                            data: data
                        });
                        $('.js-select2-district').val(1).trigger('change.select2');
                    }
                });
            });

            $('.js-select2-district').on('select2:select', function (e) {
                var data = e.params.data;
                console.log(data.id);

                var cityId = data.id;
                $.ajax({
                    type:'GET',
                    url: "{!! route('address.getNeighborhoods', '') !!}" + "/" + cityId,
                    success:function(data){
                        $('.js-select2-neighborhood').empty().select2({
                            dropdownAutoWidth : true,
                            width: 'auto',
                            placeholder: "Lütfen Mahalle Seçiniz",
                            data: data
                        });
                        $('.js-select2-neighborhood').val(1).trigger('change.select2');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.j_datepicker').datepicker({
                language: 'en-US',
                autoClose: true
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            
            if (window.File && window.FileList && window.FileReader) {
                $(".remove").click(function(){
                    $(this).parent(".pip").remove();
                });
                $("#files").on("change", function(e) {
                var files = e.target.files,
                    filesLength = files.length;
                for (var i = 0; i < filesLength; i++) {
                    var f = files[i]
                    var fileReader = new FileReader();
                    fileReader.onload = (function(e) {
                    var file = e.target;
                    $("<span class=\"pip\">" +
                        "<img class=\"imageThumb\" src=\"" + e.target.result + "\" title=\"" + file.name + "\"/>" +
                        "<br/><span class=\"remove\">Resmi Sil</span>" +
                        "</span>").insertAfter("#files");
                    $(".remove").click(function(){
                        $(this).parent(".pip").remove();
                    });
                    
                    });
                    fileReader.readAsDataURL(f);
                }
                });
            } else {
                alert("Your browser doesn't support to File API")
            }
        });
    </script>

    <!-- Summernote https://summernote.org/-->
    <script src="{{ asset('assets/plugins/summernote/summernote.min.js') }}"></script>
    <script>
        $(document).ready(function () {
            $('.summernote').summernote({
                placeholder: 'Açıklama',
                tabsize: 2,
                height: 140,
                focus: false,
                toolbar: [
                    ['font', ['bold', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']]
                ]
            });
            
        });
    </script>

    <script>
        $(function () {
            $('.money').mask("#.##0", {reverse: true});
            $(".formDate").mask("99/99/99");
            $(".formTime").mask("99/99/99 99:99");
            // $(".formCurrency").mask('#.###.###', {reverse: true});

            $("input[type='tel']").focusout(function () {
                var phone, element;
                element = $(this);
                element.unmask();
                phone = element.val().replace(/\D/g, '');
                if (phone.length > 10) {
                    element.mask("(99) 99999-9999");
                } else {
                    element.mask("(99) 9999-99999");
                }
            }).trigger('focusout');

        });
    </script>

    <script>
        $(document).ready(function() {
            
            // $('input[name="properties[property_type]"').change(function() {
            //     console.log('sa');
            // });


            $('input[name="properties[property_type]"').change(function() {
                
                var inputVal = $("input[name='properties[property_type]']:checked").val();
                $.ajax({
                    type:'GET',
                    url: "{!! route('admin.ajaxInput', '') !!}" + "/" + inputVal,
                    success:function(data){
                        console.log(data.html);
                        $('#ajaxProperties').append(data.html);
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $("#bank_select").on('change', function() {
                var bankId =  $(this).val();
                var banksWithDocuments = @json($banksJsonFormat);
                $('#contact-container').empty();
                $.each(banksWithDocuments, function (indexInArray, bank) { 
                    if(bank.id == bankId && bank.name != 'propturk') {
                        bank.documents.forEach(element => {
                            $("#contact-container").append(
                                '<div class="col-auto">'+
                                    '<input class="contracts" type="checkbox" value="'+element.id+'" name="post[contracts][]">'+
                                    '<span style="margin-right: 15px;">'+element.contract_name+'</span>'+
                                '</div>'
                            );
                        });
                    }
                    if(bank.name == 'propturk') {
                        bank.documents.forEach(element => {
                            $("#contact-container").append(
                                '<div class="col-auto">'+
                                    '<input class="contracts" type="checkbox" value="'+element.id+'" name="post[contracts][]">'+
                                    '<span style="margin-right: 15px;">'+element.contract_name+'</span>'+
                                '</div>'
                            );
                        });
                    }
                });

                $.ajax({
                    url :"{!! route('admin.getBankDepositRatio', '') !!}" + "/" + bankId,
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": bankId
                        },
                    // type: 'post',
                    dataType: 'json',
                    success: function(result)
                    {
                        $('#deposit_ratio').val(result);
                        var startPrice = $('#start_price').val();
                        var startPrice = startPrice.split('.').join("");
                        var depositRatio = $('#deposit_ratio').val();
                        var depositRatio = depositRatio.split('.').join("");
                        var process = Math.ceil(startPrice * (depositRatio / 100));
                        var process1 = process.toString();
                        var process2 = process1.match(/\d{1,3}(?=(\d{3})*$)/g);
                        var process3 = process2.join(".");
                        $('#entry_price').val(process3);
                    },
                    error: function()
                    {
                        
                    }
                });
            });

            $('#start_price').change(function() {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var depositRatio = $('#deposit_ratio').val();
                var depositRatio = depositRatio.split('.').join("");
                var entryPrice = Math.ceil(startPrice * (depositRatio / 100));
                var entryPriceProcess = entryPrice.toString();
                var entryPriceProcess = entryPriceProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var entryPriceProcess = entryPriceProcess.join(".");
            
                $('#entry_price').val(entryPriceProcess);

                var offerRatio = $('#offer_ratio').val();
                console.log(offerRatio);
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#offer_step').val(offerStepProcess);

                var propturk_deposit_ratio = $('#offer_ratio_propturk').val();
                var propturk_deposit = Math.ceil(startPrice * (propturk_deposit_ratio / 100));
                var propturkDepositProcess = propturk_deposit.toString();
                var propturkDepositProcess = propturkDepositProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var propturkDepositProcess = propturkDepositProcess.join(".");
                $('#propturk_deposit').val(propturkDepositProcess);
            });

            $('#offer_ratio_propturk').change(function () {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var offerRatio = $('#offer_ratio_propturk').val();
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#propturk_deposit').val(offerStepProcess);
            });

            $('#deposit_ratio').change(function() {

                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var depositRatio = $('#deposit_ratio').val();
                var depositRatio = depositRatio.split('.').join("");
                var process = Math.ceil(startPrice * (depositRatio / 100));
                var process1 = process.toString();
                var process2 = process1.match(/\d{1,3}(?=(\d{3})*$)/g);
                var process3 = process2.join(".");

                $('#entry_price').val(process3);
            });

            $('#offer_ratio').change(function () {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var offerRatio = $('#offer_ratio').val();
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#offer_step').val(offerStepProcess);
            });

            // $('#propturk_deposit').change(function () {
            //     var propturk_deposit_ratio = 0.0472;
            //     var startPrice = $('#start_price').val();
            //     var startPrice = startPrice.split('.').join("");
            //     var propturk_deposit = Math.ceil(startPrice * propturk_deposit_ratio);
            //     $('#propturk_deposit').val(propturk_deposit);

            // });

        });
    </script>
@endsection