@extends('admin.layout.layout')

@section('title', 'İlanlar')

@section('styles')
    @parent
    <style>
        .settings-item{
            display: flex;
            flex-direction: row;
            align-items: center;
            height: 48px;
        }
        .settings-item:hover{
            background: #a9a9a982 !important;
        }
        .modal.fade {
            z-index: 10000000 !important;
        }
        .export_document{
            text-align: end;
            margin-bottom: 15px;
        }
        .btn_datatable{
            background: transparent !important;
            border-color: #007bff !important;
            color: #007bff !important;
        }
        .btn_datatable:hover{
            background-color: transparent !important;
            opacity: 0.5 !important;
        }
        .btn-outline-primary:hover, .btn-outline-primary:active{
            background-color: transparent !important;
            opacity: 0.5 !important;
        }
    </style>
@stop

@section('content')
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Admin</a></li>
        <li class="breadcrumb-item active" aria-current="page">İlanlar</li>
    </ol>
</nav>
{{-- {{ dd($properties) }} --}}
<section class="mb-5 pb-5">
    @include('flash_message.flash')
    <header class="border-bottom mt-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-list-alt"></i> Tüm İlanlar</h3>
        <a class="btn btn-danger" href="{{ route('admin.properties.create') }}" style="margin-bottom: 7px;">İlan Ekle</a>
    </header>
    
    <div class="d-block w-100 pb-2 export_document_box text-center text-md-right mt-md-n5 pb-md-4 pt-3 pt-md-0">
    </div>
    <div class="py-3">
        <div class="">
            <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                <thead>
                    <tr class="text_small">
                        <th>İlan Kodu</th>
                        <th>Banka</th>
                        <th>Emlak Tipi</th>
                        <th>Emlak Alt Tipi</th>                  
                        <th>İlan Başlığı</th>
                        <th>İl</th>
                        <th>İlçe</th>
                        <th>Durum</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($properties as $property)
                        @if ($property->post->tender_status != 2)
                            <tr class="text-muted text_small">
                                <td class="text_small">
                                    
                                        {{ $property->post->code }}
                                    
                                </td>
                                <td>
                                    
                                        {{ $property->post->bank->name }}
                                    
                                </td>
                                <td>{{ config('enums.property_type')[$property->property_type] }}</td>
                                <td>
                                    @if (isset($property->house_type))
                                        {{ config('enums.house_type')[$property->house_type] }}
                                    @endif
                                    @if (isset($property->workplace_type))
                                        {{ config('enums.workplace_type')[$property->workplace_type] }}
                                    @endif
                                    @if (isset($property->land_type))
                                        {{ config('enums.land_type')[$property->land_type] }}
                                    @endif
                                    
                                </td>                                        
                                <td class="text_small">
                                    @isset($property->post->title)
                                        {{ $property->post->title }}
                                    @endisset
                                    
                                </td>
                                <td class="text-center">{{ $property->country }}</td>
                                <td class="text-center">{{ $property->district }}</td>
                                <td class="text-center">
                                    {{ config('enums.tender_status')[$property->post->tender_status] }}
                                </td>
                                <td>
                                    {{--  <div class="btn-group w-100" role="group" aria-label="Controls">
                                        <a title='İlanı Gör'  href='' class='btn btn-sm btn-success '><i class="far fa-eye"></i></a>
                                        <a title='İlan Düzenle' href='{{ route('admin.properties.edit', ['property' => $property->slug]) }}' class='post_single_center btn btn-sm btn-info'><i class="far fa-edit"></i></a>
                                        @if ($property->post->tender_status == 0)
                                            <a title='İlanı Aktive Et' href='{{ route('admin.setTenderStatusActive', ['id' => $property->post->id]) }}' class='post_single_center btn btn-sm btn-danger'><i class="fas fa-play"></i></a>
                                        @endif
                                    </div>  --}}
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="settingsMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            İşlemler <i class="fa fa-cog" aria-hidden="true"></i>
                                        </button>
                                        <div class="dropdown-menu p-0" aria-labelledby="settingsMenuButton" style="border-radius: 0px;">
                                          <a class="dropdown-item settings-item" href="{{ route('admin.properties.show', ['slug' => $property->slug]) }}">İlanı Gör</a>
                                          <a class="dropdown-item settings-item" href="{{ route('admin.properties.edit', ['property' => $property->slug]) }}">İlanı Düzenle</a>
                                          <a class="dropdown-item settings-item" href="{{ route('admin.getTenderReportPdf', ['id' => $property->id]) }}">Rapor İndir</a>
                                          <a class="dropdown-item settings-item" href="{{ route('admin.archiveFiles.index', ['slug' => $property->slug]) }}">Arşive Dosya Ekle</a>
                                          {{-- <a class="dropdown-item settings-item" href="#" data-toggle="modal" data-target="#bannerformmodal">İlanı Çoğalt</a> --}}
                                        @if ($property->post->tender_status == 0)
                                            <button type="button" class="dropdown-item settings-item count-modal" data-toggle="modal" data-target="#duplicateModal" id={{ $property->id }}>
                                                İlanı Çoğalt
                                            </button>    
                                            <a class="dropdown-item settings-item" href="{{ route('admin.setTenderStatusActive', ['id' => $property->post->id]) }}">İlanı Aktif Et</a>
                                            @if(Auth::user()->is_admin == 1)
                                                <form method="POST" action="{{ route('admin.properties.destroy', ['property' => $property->slug]) }}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="dropdown-item settings-item" style="color: red">Sil</button>
                                                </form>
                                            @endif
                                        @endif
                                        @if ($property->post->tender_status == 1)
                                            @if($property->post->winner_id == NULL)
                                                <a class="dropdown-item settings-item" href="{{ route('admin.setTenderStatusPassive', ['id' => $property->post->id]) }}">İlanı Pasif Yap</a>
                                            @endif
                                        @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>

        </div>

        <div class="" style="border-top: 1px solid #dee2e6!important;padding-top:25px;margin-top:55px;">
            <h2>İhalesi Tamamlananlar</h2>
            <table class="table table-striped table-bordered table-hover dataTables-finished w-100" >
                <thead>
                    <tr class="text_small">
                        <th>İlan Kodu</th>
                        <th>Banka</th>
                        <th>Emlak Tipi</th>
                        <th>Emlak Alt Tipi</th>                  
                        <th>İlan Başlığı</th>
                        <th>İl</th>
                        <th>İlçe</th>
                        <th>Durum</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($properties as $property)
                        @if ($property->post->tender_status == 2)
                            <tr class="text-muted text_small">
                                <td class="text_small">
                                    
                                    {{ $property->post->code }}
                                    
                                </td>
                                <td>
                                    
                                    {{ $property->post->bank->name }}
                                    
                                </td>
                                <td>{{ config('enums.property_type')[$property->property_type] }}</td>
                                <td>
                                    @if (isset($property->house_type))
                                        {{ config('enums.house_type')[$property->house_type] }}
                                    @endif
                                    @if (isset($property->workplace_type))
                                        {{ config('enums.workplace_type')[$property->workplace_type] }}
                                    @endif
                                    @if (isset($property->land_type))
                                        {{ config('enums.land_type')[$property->land_type] }}
                                    @endif
                                    
                                </td>                                        
                                <td class="text_small">
                                    @isset($property->post->title)
                                        {{ $property->post->title }}
                                    @endisset
                                    
                                </td>
                                <td class="text-center">{{ $property->country }}</td>
                                <td class="text-center">{{ $property->district }}</td>
                                <td class="text-center">
                                    {{ config('enums.tender_status')[$property->post->tender_status] }}
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="settingsMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            İşlemler <i class="fa fa-cog" aria-hidden="true"></i>
                                        </button>
                                        <div class="dropdown-menu p-0" aria-labelledby="settingsMenuButton" style="border-radius: 0px;">
                                            <a class="dropdown-item settings-item" href="{{ route('admin.properties.show', ['slug' => $property->slug]) }}">İlanı Gör</a>
                                            <a class="dropdown-item settings-item" href="{{ route('admin.getTenderReportPdf', ['id' => $property->id]) }}">Rapor İndir</a>
                                            <a class="dropdown-item settings-item" href="{{ route('admin.archiveFiles.index', ['slug' => $property->slug]) }}">Arşive Dosya Ekle</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

</section>

<!-- Modal -->
<div class="modal fade" id="duplicateModal" tabindex="-1" role="dialog" aria-labelledby="duplicateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="duplicateModalLabel">İlanı Çoğalt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="post" id="_tenderForm">
                @csrf
                <div class="modal-body">
                    <div class="form-row" style="display: flex;justify-content: center;">
                        <div class="col-md-8" style="display: flex;flex-direction: column;align-items: center;">
                            <label for="tender_count">Bu ilanı kaç kere çoğaltmak istiyorsunuz?</label>
                            <input type="number" class="form-control" name="tender_count" id="_tenderCount" value="0" step="1" min="0" style="width: 150px;border-radius:0;" />
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="_saveTenderCount">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>
@stop

@section('scripts')
    @parent
    
    <script>

        $(document).ready(function () {
            $(".count-modal").click(function() {
                var modalId = $(this).attr('id');
                console.log(modalId);
                var url = "{{route('admin.properties.clone', '')}}"+"/"+modalId+"";
                $('#_tenderForm').attr('action', url);
            });

            $('.dataTables-imobi').DataTable({
                responsive: true,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "_TOTAL_ kayıttan _START_ ile _END_ arası kadar gösteriliyor",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of _MAX_ records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ bir sayfada gözüken veri sayısı",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'Devam_Eden_ihaleler_CSV',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'Devam_Eden_ihaleler_Excel',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'Devam_Eden_ihaleler_PDF',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'Devam Eden İhaleler',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

            //        $(".dataTables_wrapper").addClass("d-flex justify-content-between flex-wrap");
            $(".btn_datatable").removeClass("btn-secondary").addClass("btn-outline-primary");
            $('.export_document').prependTo('.export_document_box');

            $('.dataTables-finished').DataTable({
                responsive: true,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "_TOTAL_ kayıttan _START_ ile _END_ arası kadar gösteriliyor",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of _MAX_ records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ bir sayfada gözüken veri sayısı",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'İhalesi_Tamamlananlar_CSV',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'İhalesi_Tamamlananlar_Excel',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'İhalesi_Tamamlananlar_PDF',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'İhalesi Tamamlananlar',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

        });
    </script>
@endsection