@extends('admin.layout.layout')

@section('title', 'Kullanıcı Ekle')

@section('styles')
    @parent
@stop

@section('content')
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb bg-transparent p-0 text_small">
            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Admin</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Kullanıcılar</a></li>
            <li class="breadcrumb-item active">Kullanıcı Oluştur</li>
        </ol>
    </nav>

    <section class="mb-5 pb-5">
        <header class="border-bottom my-4">
            <h3 class="text-primary font-weight-light"><i class="far fa-id-badge"></i> Kullanıcı Oluştur</h3>
        </header>

        <div class="row py-3">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div class="py-3">
                    
                    <form class="auto_save text-muted" method="POST" action="{{ route('admin.users.store') }}">
                        @csrf
                        <div class="form-row">
                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="identity_number">Kimlik Numarası:</label>
                                    <input class="form-control" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"  value="" maxlength="11" minlength="11" type="text" name="identity_number" id="identity_number" placeholder="Kimlik Numarası" >
                                </div>
                            </div> 
                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="phone_number">Telefon Numarası:</label>
                                    <input type="text" name="phone_number"  class="form-control" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');" id="phone_number" aria-describedby="phoneHelp" placeholder="0 (535) 555-55-55" required>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="name">Ad:</label>
                                    <input class="form-control"  value="" type="text" name="name" id="name" placeholder="Ad" required>
                                </div>
                            </div>
                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="surname">Soyad:</label>
                                    <input class="form-control" value="" type="text" name="surname" id="surname" placeholder="Soyad" required>
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-md-12 col-lg-4">
                                <div class="form-group">
                                    <label for="surname">Şirket Ünvanı:</label>
                                    <input class="form-control" value="" type="text" name="company_name" placeholder="Şirket Ünvanı">
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-12 col-lg-4">
                                <div class="form-group">
                                    <label for="surname">Şirket Vergi Dairesi:</label>
                                    <input class="form-control" value="" type="text" name="company_tax_office" placeholder="Şirket Vergi Dairesi">
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-12 col-lg-4">
                                <div class="form-group">
                                    <label for="surname">Şirket Vergi No:</label>
                                    <input class="form-control" value="" type="text" name="company_tax_id" placeholder="Şirket Vergi No">
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <div class="form-group">
                                    <label for="email">Eposta Adresi:</label>
                                    <input class="form-control"  value="" type="email" name="email" id="email" placeholder="E-mail" required>
                                </div>
                            </div>

                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="password">Şifre:</label>
                                    <input type="text" name="password"  id="password" class="form-control" placeholder="Şifre" />
                                </div>
                            </div>

                            <div class="col-sm-6 col-md-12 col-lg-6">
                                <div class="form-group">
                                    <label for="user_password_re">Şifre Tekrar:</label>
                                    <input type="text" id="user_password_re" class="form-control" placeholder="Şifre Tekrar"/>
                                    {{-- <span style="color:red;display:none;" id="re-pw-warning">Şifreler Uyuşmuyor</span>
                                    <i class="fas fa-check-circle" style="display: none;" id="re-pw-pass"></i> --}}
                                </div>
                            </div>
                            
                            @if(Auth::user()->is_admin == 1)
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="is_admin">Kullanıcı Rolü Seçiniz</label>
                                        <select class="form-control" name="is_admin" id="selectRole">
                                            <option value="0" checked>Normal Kullanıcı</option>
                                            <option value="1">Admin</option>
                                            <option value="2">Yetkili Çalışan</option>
                                        </select>
                                    </div>
                                </div>
                            @else
                                <input type="hidden" name="is_admin" value="0">
                            @endif
                            
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <div class="form-group" id="propertiesId">
                                    <label for="user_password">İhaleler:</label>
                                    <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                                        <thead>
                                            <tr class="text_small">
                                                <th></th>
                                                <th>İlan Kodu</th>
                                                <th>Banka</th>
                                                <th>Emlak Tipi</th>
                                                <th>Emlak Alt Tipi</th>                  
                                                <th>İlan Başlığı</th>
                                                <th>İl</th>
                                                <th>İlçe</th>
                                                <th>Durum</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($posts as $post)
                                                <tr class="text-muted text_small">
                                                    <td style="text-align: center;vertical-align: middle;">
                                                        <input type="checkbox" value="0" class="input-check" name="{{ $post->id }}">
                                                    </td>
                                                    <td class="text_small">{{ $post->code }}</td>
                                                    <td class="text_small">{{ $post->bank->name }}</td>
                                                    <td>{{ config('enums.property_type')[$post->postable->property_type] }}</td>
                                                    <td>
                                                        @isset($post->postable->house_type)
                                                            {{ config('enums.house_type')[$post->postable->house_type] }}
                                                        @endisset
                                                        @isset($post->postable->workplace_type)
                                                            {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                        @endisset
                                                        @isset($post->postable->land_type)
                                                            {{ config('enums.land_type')[$post->postable->land_type] }}
                                                        @endisset
                                                    </td>                                        
                                                    <td class="text_small">{{ $post->title }}</td>
                                                    <td class="text-center">{{ $post->postable->country }}</td>
                                                    <td class="text-center">{{ $post->postable->district }}</td>
                                                    <td class="text-center">{{ config('enums.tender_status')[$post->tender_status] }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            
                        </div>


                        <div class="text-right pt-4">
                            <button type="submit" class="btn btn-lg btn-danger slow_3s  position-relative px-5">Kullanıcı Oluştur
                                <span class="form_load position-absolute">
                                    <span class="spinner-border text-light" role="status">
                                        <span class="sr-only">Loading...</span>
                                    </span>
                                </span>
                            </button>
                        </div>
                    </form>
                    @if($errors->any())
                        <div class="mt-2 mb-2">
                            @foreach($errors->all() as $error)
                                <div class="alert alert-danger" role="alert">
                                    {{ $error }}
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </section>
@stop

@section('scripts')
    @parent
    <script type='text/javascript' src="https://rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js"></script>
    <script>
        $(function () {
            $("#phone_number").inputmask({"mask": "9 (999) 999-99-99"});
        });
    </script>
    <script>
        $( document ).ready(function() {
            // $('.input-check').click(function() {
            //     $(this).toggle(
            //         function () { 
            //             $(this).val("1"); 
            //         },
            //         function () { 
            //             $(this).val("0");
            //         }
            //     );
            // });

            $(".input-check").change(function() {
                if(this.checked) {
                    $(this).val("1");
                }else{
                    $(this).val("0");
                }
            });

            $('#selectRole').on('change', function() {
                // console.log($(this).val());
                if ($(this).val() == 1) {
                    $('#propertiesId').css('display', 'none');
                } 
                if($(this).val() == 2) {
                    $('#propertiesId').css('display', 'none');
                }
                if ($(this).val() == 0) {
                    $('#propertiesId').css('display', 'block');
                }
            });

            // $("#user_password_re").blur(function(){  
            //     if ($('#password').attr('value') == $('#user_password_re').attr('value')) {
            //         $('#re-pw-pass').css('display', 'block');
            //     }else {
            //         $('#re-pw-warning').css('display', 'block');
            //     }
            // });  
        });
    </script>
@endsection