@extends('admin.layout.layout')

@section('title', 'Kullanıcı Düzenle')

@section('styles')
    @parent
@stop

@section('content')
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Admin</a></li>
        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Kullanıcılar</a></li>
        <li class="breadcrumb-item active">Kullanıcı Düzenle</li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-id-badge"></i> Kullanıcı Düzenle</h3>
        <h4 style="margin-top: 25px;">{{ $user->name }} {{ $user->surname }}</h4>
    </header>

    <div class="row py-3">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="tab-content" id="pills-tabContent">
                <section class="tab-pane fade show active" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <div class="py-3">
                        <form class="auto_save text-muted" action="{{ route('admin.users.update', ['user' => $user->id]) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="form-row">
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="identity_number">Kimlik Numarası:</label>
                                        <input class="form-control" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"  value="{{ $user->identity_number }}" maxlength="11" minlength="11" type="text" name="identity_number" id="identity_number" placeholder="Kimlik Numarası" >
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="phone_number">Telefon Numarası:</label>
                                        <input type="text" name="phone_number" class="form-control" minlength="11" id="phone_number" value="0{{ $user->phone_number }}" aria-describedby="phoneHelp" placeholder="0 (535) 555-55-55" required>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="name">Ad:</label>
                                        <input class="form-control"  value="{{ $user->name }}" type="text" name="name" id="name" placeholder="Ad" required>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="surname">Soyad:</label>
                                        <input class="form-control" value="{{ $user->surname }}" type="text" name="surname" id="surname" placeholder="Soyad" required>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="surname">Şirket Ünvanı:</label>
                                        <input class="form-control" value="{{ $user->company_name }}" type="text" name="company_name" placeholder="Şirket Ünvanı">
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="surname">Şirket Vergi Dairesi:</label>
                                        <input class="form-control" value="{{ $user->company_tax_office }}" type="text" name="company_tax_office" placeholder="Şirket Vergi Dairesi">
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="surname">Şirket Vergi No:</label>
                                        <input class="form-control" value="{{ $user->company_tax_id }}" type="text" name="company_tax_id" placeholder="Şirket Vergi No">
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-group">
                                        <label for="email">Eposta Adresi:</label>
                                        <input class="form-control"  value="{{ $user->email }}" type="email" name="email" id="email" placeholder="E-mail" required>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-12">
                                    <div class="form-group">
                                        <label for="address">Adres:</label>
                                        <textarea class="form-control"  cols="10" rows="2" type="address" name="address" id="address" placeholder="Adres">{{ $user->address }}</textarea>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="password">Şifre:</label>
                                        <input type="text" name="password"  id="password" class="form-control" placeholder="Şifre" />
                                    </div>
                                </div>

                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="user_password_re">Şifre Tekrar:</label>
                                        <input type="text" id="user_password_re" class="form-control" placeholder="Şifre Tekrar" />
                                    </div>
                                </div>


                                @if(Auth::user()->is_admin == 1)
                                    <div class="col-sm-6 col-md-12 col-lg-6">
                                        <div class="form-group">
                                            <label for="is_admin">Kullanıcı Rolü Seçiniz</label>
                                            <select class="form-control" name="is_admin" id="selectRole">
                                                    <option
                                                        value="0"
                                                        @if ($user->is_admin == 0)
                                                            selected
                                                        @endif>Normal Kullanıcı
                                                    </option>
                                                    <option
                                                        value="1"
                                                        @if ($user->is_admin == 1)    
                                                            selected
                                                        @endif>Admin
                                                    </option>
                                                    <option  
                                                        value="2"
                                                        @if ($user->is_admin == 2)    
                                                            selected
                                                        @endif>Yetkili Çalışan
                                                    </option>
                                            </select>
                                        </div>
                                    </div>
                                @else
                                    <input type="hidden" name="is_admin" value="0">
                                @endif

                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-group" id="propertiesId">
                                        <label for="user_password">Aktif İhaleler:</label>
                                        <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                                            <thead>
                                                <tr class="text_small">
                                                    <th></th>
                                                    <th>İlan Kodu</th>
                                                    <th>Banka</th>
                                                    <th>Emlak Tipi</th>
                                                    <th>Emlak Alt Tipi</th>                  
                                                    <th>İlan Başlığı</th>
                                                    <th>İl</th>
                                                    <th>İlçe</th>
                                                    <th>Durum</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($posts as $post)
                                                    <tr class="text-muted text_small">
                                                        <td style="text-align: center;vertical-align: middle;">
                                                            <input type="checkbox"
                                                            @if(in_array($post->id, $userPermissionArray))
                                                                checked
                                                                value="1"
                                                            @else
                                                                value="0"
                                                            @endif
                                                            class="input-check" 
                                                            name="{{ $post->id }}">
                                                        </td>
                                                        <td class="text_small">{{ $post->code }}</td>
                                                        <td class="text_small">{{ $post->bank->name }}</td>
                                                        <td>{{ config('enums.property_type')[$post->postable->property_type] }}</td>
                                                        <td>
                                                            @isset($post->postable->house_type)
                                                                {{ config('enums.house_type')[$post->postable->house_type] }}
                                                            @endisset
                                                            @isset($post->postable->workplace_type)
                                                                {{ config('enums.workplace_type')[$post->postable->workplace_type] }}
                                                            @endisset
                                                            @isset($post->postable->land_type)
                                                                {{ config('enums.land_type')[$post->postable->land_type] }}
                                                            @endisset
                                                        </td>                                        
                                                        <td class="text_small">{{ $post->title }}</td>
                                                        <td class="text-center">{{ $post->postable->country }}</td>
                                                        <td class="text-center">{{ $post->postable->district }}</td>
                                                        <td class="text-center">{{ config('enums.tender_status')[$post->tender_status] }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                
                            </div>


                            <div class="text-right pt-4">
                                <button type="submit" class="btn btn-lg btn-danger slow_3s  position-relative px-5">Kaydet
                                    <span class="form_load position-absolute">
                                        <span class="spinner-border text-light" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </span>
                                    </span>
                                </button>
                            </div>
                        </form>

                        @if($errors->any())
                            <div class="mt-2 mb-2">
                                @foreach($errors->all() as $error)
                                    <div class="alert alert-danger" role="alert">
                                        {{ $error }}
                                    </div>
                                @endforeach
                            </div>
                        @endif
                        
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
@stop

@section('scripts')
    @parent
    <script type='text/javascript' src="https://rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js"></script>
    <script>
        $(function () {
            $("#phone_number").inputmask({
                "mask": "9 (999) 999-99-99"
                });
        });
        // $('.inputmask_alphanumeric').inputmask({ mask: "{11}", greedy: false });

    </script>
    
    <script>
        
        $(document).ready(function() {
            $(".input-check").change(function() {
                if(this.checked) {
                    $(this).val("1");
                }else{
                    $(this).val("0");
                }
            });

            if ($(this).val() == 1) {
                $('#propertiesId').css('display', 'none');
            } 
            if($(this).val() == 2) {
                $('#propertiesId').css('display', 'none');
            }
            if ($(this).val() == 0) {
                $('#propertiesId').css('display', 'block');
            }

            $('#selectRole').on('change', function() {
                // console.log($(this).val());
                if ($(this).val() == 1) {
                    $('#propertiesId').css('display', 'none');
                } 
                if($(this).val() == 2) {
                    $('#propertiesId').css('display', 'none');
                }
                if ($(this).val() == 0) {
                    $('#propertiesId').css('display', 'block');
                }
            });
        });
    </script>
@endsection