@extends('layout.layout')

@section('title', 'Kayıt Ol')

@section('styles')
    @parent
    <style>
        .sms-info-i{
            color: rgb(117, 112, 112);
            cursor: pointer;
        }
        .warning-info-box{
            display: none;
            position: absolute;
            width: 172px;
            left: 193px;
            top: -20px;
            z-index: 2;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
        }
        .sms-info-i:hover ~ .warning-info-box{
            display: block !important;
        }

        /* The message box is shown when the user clicks on the password field */
        #message {
            display: none;
            background: white;
            color: #000;
            padding: 10px;
            margin-top: 10px;
            width: 55%;
            border: 1px solid #ddd;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
            z-index: 2;
            position: absolute;
            top: -5px;
            left: 388px;
        }

        @media screen and (max-width:950px) {
            #message {
                width: 70%;
                top: 90px;
                left: 0px;
            }
        }

        #message p {
            padding: 0px 35px;
            font-size: 11px;
            margin-bottom:0px; 
        }

        /* Add a green text color and a checkmark when the requirements are right */
        .valid {
            color: green;
        }

        .valid:before {
            position: relative;
            left: -35px;
            content: "✔";
        }

        /* Add a red text color and an "x" when the requirements are wrong */
        .invalid {
            color: red;
        }

        .invalid:before {
            position: relative;
            left: -35px;
            content: "✖";
        }
    </style>
@stop

@section('content')
     <!-- start main container -->
     <main class="bg-light bg_parallax">
        <div class="container py-5">
            <div class="row justify-content-center">
                <div class='py-5 px-3 px-md-5 my-3 col-lg-10 col-xl-8 shadow bg-white text-left'>
                    <div class="text-center">
                        <a class="main_brand d-inline-block" href="{{ route('home') }}" title="Markest - Ana Sayfa">
                            <img class="d-block w-100" src="{{ asset('assets/img/logo.png') }}" alt="Markest" title="Markest"/>
                        </a>
                        <h2 class="font-weight-bold h4">Üye Ol</h2>
                        <p class="tagline text-body mb-3">Lütfen kayıt bilgilerinizi giriniz!</p>
                    </div>
                    <form method="POST" action="{{ route('register') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">Ad:<span style="color:red">*</span></label>
                                    <input type="text" name="name" maxlength="35" class="form-control" id="name" placeholder="Ad" value="{{ old('name') }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="surname">Soyad:<span style="color:red">*</span></label>
                                    <input type="text" name="surname" maxlength="35" class="form-control" id="surname" placeholder="Soyad:" value="{{ old('surname') }}" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="company_name">Şirket Ünvanı:</label>
                                    <input type="text" name="company_name" class="form-control" placeholder="Şirket Ünvanı" value="{{ old('company_name') }}">
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_tax_office">Şirket Vergi Dairesi:</label>
                                    <input type="text" name="company_tax_office" class="form-control" placeholder="Şirket Vergi Dairesi" value="{{ old('company_tax_office') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_tax_id">Şirket Vergi No:</label>
                                    <input type="text" name="company_tax_id" class="form-control" placeholder="Şirket Vergi No" value="{{ old('company_tax_id') }}">
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Eposta Adresi:<span style="color:red">*</span></label>
                                    <input type="email" name="email"  class="form-control" id="email" aria-describedby="emailHelp" value="{{ old('email') }}" placeholder="Eposta Adresi" required>
                                    {{-- <small id="emailHelp" class="form-text text-muted">We will never share your email with anyone else.</small> --}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phone_number">Telefon Numarası:<span style="color:red">*</span></label>
                                    <input type="text" name="phone_number" class="form-control" id="phone_number" aria-describedby="phoneHelp" value="{{ old('phone_number') }}" placeholder="0 (535) 555-55-55" required>
                                    {{-- <small id="emailHelp" class="form-text text-muted">We will never share your email with anyone else.</small> --}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sms_permission">Sms Bilgilendirme:</label>
                                    <input type="checkbox" name="sms_permission"  value="1" checked>
                                    <i class="fa fa-question-circle sms-info-i" aria-hidden="true"></i>
                                    <div class="warning-info-box">
                                        <div style="padding: 5px;background:white;border: 1px solid #ddd;">
                                            <p class="mb-0" style="color: black;font-weight:600;font-size:11px;">İhale sürecinde sms üzerinden bilgi almanızı sağlar.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password">Şifre:<span style="color:red">*</span></label>
                                    <input type="password" name="password" class="form-control" id="password" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}" placeholder="Şifre" required>
                                </div>
                                <div id="message">
                                    <h3 style="font-size: 11px;">Şifre için istenilen model:</h3>
                                    <p id="letter" class="invalid">En az bir <b>küçük</b> harf</p>
                                    <p id="capital" class="invalid">En az bir <b>büyük</b> harf</p>
                                    <p id="number" class="invalid">En az bir <b>sayı</b></p>
                                    <p id="length" class="invalid">En az <b>8 karakter</b></p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="password-confirm">Şifre Tekrar:<span style="color:red">*</span></label>
                                    <input type="password" name="password_confirmation" class="form-control" id="password-confirm" placeholder="Şifre Tekrar" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6 text-center mb-2">
                                <div>
                                    <input type="checkbox" required>
                                    <span><a href="{{ route('privacyPolicy') }}" style="color: black;">Gizlilik ve Veri Politikası</a> Okudum Onaylıyorum<span style="color:red">*</span></span>
                                </div>
                            </div>
                            <div class="col-md-6 text-center">
                                <div>
                                    <input type="checkbox" required>
                                    <span></span><a href="{{ route('kvkk') }}" style="color: black;">Aydınlatma Metni</a> Okudum Onaylıyorum<span style="color:red">*</span></span>
                                </div>
                            </div>
                        </div>
                        @if(env('GOOGLE_RECAPTCHA_KEY'))
                            <div class="g-recaptcha"
                                data-sitekey="{{env('GOOGLE_RECAPTCHA_KEY')}}">
                            </div>
                        @endif
                        <button style="background-color: #38B6FF;" type="submit" class="btn text-light btn-block py-3 mt-2">Üye Ol!</button>
                    </form>
                    @if($errors->any())
                        <div class="mt-2 mb-2">
                            @foreach($errors->all() as $error)
                                <div class="alert alert-danger" role="alert">
                                    {{ $error }}
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

            </div>
        </div>

    </main>
    <!-- end main container -->
@stop

@section('scripts')
    @parent
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script type='text/javascript' src="https://rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js"></script>
    <script>
        $(function () {
            $("#phone_number").inputmask({"mask": "9 (999) 999-99-99"});
        });


        var myInput = document.getElementById("password");
        var letter = document.getElementById("letter");
        var capital = document.getElementById("capital");
        var number = document.getElementById("number");
        var length = document.getElementById("length");

        // When the user clicks on the password field, show the message box
        myInput.onfocus = function() {
        document.getElementById("message").style.display = "block";
        }

        // When the user clicks outside of the password field, hide the message box
        myInput.onblur = function() {
        document.getElementById("message").style.display = "none";
        }

        // When the user starts to type something inside the password field
        myInput.onkeyup = function() {
        // Validate lowercase letters
        var lowerCaseLetters = /[a-z]/g;
        if(myInput.value.match(lowerCaseLetters)) {  
            letter.classList.remove("invalid");
            letter.classList.add("valid");
        } else {
            letter.classList.remove("valid");
            letter.classList.add("invalid");
        }
        
        // Validate capital letters
        var upperCaseLetters = /[A-Z]/g;
        if(myInput.value.match(upperCaseLetters)) {  
            capital.classList.remove("invalid");
            capital.classList.add("valid");
        } else {
            capital.classList.remove("valid");
            capital.classList.add("invalid");
        }

        // Validate numbers
        var numbers = /[0-9]/g;
        if(myInput.value.match(numbers)) {  
            number.classList.remove("invalid");
            number.classList.add("valid");
        } else {
            number.classList.remove("valid");
            number.classList.add("invalid");
        }
        
        // Validate length
        if(myInput.value.length >= 8) {
            length.classList.remove("invalid");
            length.classList.add("valid");
        } else {
            length.classList.remove("valid");
            length.classList.add("invalid");
        }
        }
    </script>
@endsection