<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        h1{
            font-size: 16px;
        }
        h2{
            font-size: 14px;
        }
        p{
            font-size: 12px;
        }
        .head-p1{
            font-size: 28px;
            color: cadetblue;
        }
        .head-p2{
            font-size: 26px;
            color: cadetblue;
        }
        .head-p3{
            font-size: 24px;
            color: black;
        }
        .max-table{
            max-width: 2480px;
            width:100%;
        }
        .max-table td{
            width: auto;
            overflow: hidden;
            word-wrap: break-word;
        }

    </style>
</head>
<body>
    <div align="center" style="border:2px solid cadetblue;">
        <br/>
        <p class="head-p1">
            <strong>{{ $post_code }}.</strong>
        </p>
        <p class="head-p2">
            <strong>{{ $post_title }}</strong>
        </p>
        <p class="head-p3">
            <strong>{{ $post_start_date }} - {{ $post_end_date }}</strong>
        </p>
        <br/>
        <br/>
        <br/>
        <img
            src="{{ $post_image }}"
            width="461"
            height="346"
        />
        <br/>
        <br/>
        <p>
           <strong>{{ $city }}, {{ $district }}</strong>
        </p>
        <br/>
        <br/>
        <br/>
        <br/>
        <img
            src="{{ $bank_logo }}"
            width="195"
            height="84"
        />
        <br/>
    </div>
    <br/>

    <div style="float:none;break-after:page"></div>
    <h1 dir="ltr">
        {{ $post_code }} Emlak Kodlu Gayrımenkule Ait Bilgiler
    </h1>
    <p dir="ltr">
        Şehir: {{ $city }}
    </p>
    <p dir="ltr">
        İlçe: {{ $district }}
    </p>
    <p dir="ltr">
        Mahalle: {{ $neighborhood }}
    </p>
    <p dir="ltr">
        Ada No: {{ $city_block_no }}
    </p>
    <p dir="ltr">
        Parsel No: {{ $parcel_no }}
    </p>
    <p dir="ltr">
        Kat No: {{ $floor_no }}
    </p>
    <p dir="ltr">
        Blok No: {{ $block_no }}
    </p>
    <p dir="ltr">
        Bağımsız Bölüm No: {{ $independent_section_no }}
    </p>
    <p dir="ltr">
        Adres: {{ $address }}
    </p>
    <p dir="ltr">
        İlana Çıkış {{ $post_start_date_formatted }}
    </p>
    <br/>
    <div style="break-after:page"></div>
    <h1 dir="ltr">
        İhale Tarihçesi
    </h1>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="5">
            
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            Başlangıç
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Bitiş
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Başlangıç Bedeli
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Min. Artış
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            İstekli Sayısı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Teklif Sayısı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En İyi Teklif
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            İzlenme Sayısı
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <p dir="ltr">
                            {{ $post_start_date_formatted }}
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $post_end_date_formatted }}
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $start_price }}₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $offer_step }}₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $post_user_count }}
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $post_offer_count }}
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ number_format($best_price, 0, '.', '.')  }}₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $post_view_count }}
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <p dir="ltr">
        Katılımcılar ve Tekliflerine Ait Bilgiler
    </p>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="5">
            
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            İstekli Adı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            T.C. Kimlik No
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Cep Tel
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            E-posta
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Kaydı alan Şube
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En Yüksek Teklifi
                        </p>
                    </td>
                </tr>
                @foreach ($post_with_user as $item)
                    <tr>
                        <td>
                            <p dir="ltr">
                                {{ $item->user->name }} {{ $item->user->surname }}
                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                {{ $item->user->identity_number }}
                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                {{ $item->user->phone_number }}
                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                <a href="mailto:{{ $item->user->email }}">
                                    {{ $item->user->email }}
                                </a>
                            </p>
                        </td>
                        <td>
                            <br/>
                        </td>
                        <td>
                            <p dir="ltr">
                                {{ number_format($item->price, 0, '.', '.'), }}₺
                            </p>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <br/>
    <br/>
    <br/>
    <br/>
    <br/>
    <div style="break-after:page"></div>
    <h1 dir="ltr">
        Teklif Listesi
    </h1>
    @foreach ($post_with_user as $key => $item)
        <p dir="ltr">
            {{ $key }} - {{ $item->user->name }} {{ $item->user->surname }} - {{ number_format($item->price, 0, '.', '.'), }}₺ / {{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y H:i') }}
        </p>
    @endforeach
    <br/>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="15">
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            Başlangıç Bedeli
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En İyi Teklif
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Yüzde Artış
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Artış Miktarı
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <p dir="ltr">
                            {{ $start_price }}₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ number_format($best_price, 0, '.', '.')  }}₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            % {{ $offerPercentageRise }}
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            {{ $offer_step }}₺
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <h1 dir="ltr">
        Tapu Bilgileri
        <br/>
    </h1>
    <p dir="ltr">
        Taşınmazın tapu devri, ihaleyi kazanan isteklinin talebi doğrultusunda
        aşağıda belirtilen kişiler ve hisse oranları çerçevesinde yapılacaktır:
    </p>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="0">
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            T.C. Kimlik No
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Ad
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Soyad
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Pay
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <p dir="ltr">
                            Toplam
                        </p>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <h1 dir="ltr">
        Sonuç
    </h1>
    <p dir="ltr">
        {{ $post_code }}. nolu {{ $post_title }} isimli gayrimenkulün satış
        ihalesi {{ $post_start_date }} - {{ $post_end_date }} tarihleri arasında gerçekleştirilmiş olup, ihaleyi
        {{ number_format($best_price, 0, '.', '.')  }}₺ ile en yüksek teklif veren {{ $winner->name }} {{ $winner->surname }} kazanmıştır.
    </p>
    <div>
        <br/>
    </div>
</body>
</html>