@extends('layout.layout')

@section('title', 'Arama Sonuçları')

@section('styles')
    @parent
    <style>
        .select2-selection__rendered {
            line-height: 48px !important;
            border-radius: 0 !important;
            border: none !important;
        }
        .select2-container .select2-selection--single {
            height: 48px !important;
            border-radius: 6px !important;
            border: none !important;
        }
        .select2-selection__arrow {
            height: 48px !important;
            border-radius: 0 !important;
            border: none !important;
        }
        .select2-container{
            max-width: 75% !important;
            border: none !important;
        }
        .select2-container--default .select2-selection--single{
            background-color: #f8f9fa !important;
            border: none !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered{
            font-size: 19px;
            color: #6c757d!important;
        }
        .search-select-span{
            background: #F5F8FA;
            border-bottom-left-radius: 6px;
            border-top-left-radius: 6px;
            border:none !important;
            color:#5E6278
        }
        .search-select-span i{
            font-size: 17px;
        }
        .search-select{
            background-color: #F5F8FA;
            border:none !important;
            border-bottom-right-radius: 6px !important;
            border-top-right-radius: 6px !important;
            color:#5E6278;
            font-size: 17px !important;
            line-height: 16px !important;
            padding-left: 5px !important;
        }
        .input-select2{
            display: flex !important;
            flex-wrap: nowrap !important;
        }

        @media screen and (max-width:900px) {
            .mobile-grid{
                grid-gap: 20px;
            }
            .select2-container{
                max-width: 100% !important;
            }
        }

        .min-price{
            border-radius: 6px !important;
            font-size: 14px !important;
        }

        .max-price{
            border-radius: 6px !important;
            font-size: 14px !important;
        }

        .min-price:focus{
            box-shadow: 0 0 0 0.25rem rgb(13 110 253 / 0%) !important;
        }

        .max-price:focus{
            box-shadow: 0 0 0 0.25rem rgb(13 110 253 / 0%) !important;
        }

        .min-price::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
            font-size: 14px;
            opacity: 0.5;
        }

        .min-price:-ms-input-placeholder { /* Internet Explorer 10-11 */
            font-size: 14px;
            opacity: 0.5;
        }

        .min-price::-ms-input-placeholder { /* Microsoft Edge */
            font-size: 14px;
            opacity: 0.5;
        }

        .max-price::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
            font-size: 14px;
            opacity: 0.5; /* Firefox */
        }

        .max-price:-ms-input-placeholder { /* Internet Explorer 10-11 */
            font-size: 14px;
            opacity: 0.5;
        }

        .max-price::-ms-input-placeholder { /* Microsoft Edge */
            font-size: 14px;
            opacity: 0.5;
        }

        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:12px;
            font-size: 15px;
            color: #5e6278;
        }
        
        .text-currency{
            padding:10px 25px;
            border:solid 1px #ccc;
            border-radius:5px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow b{
            background-image: url("/assets/img/select2.svg") !important;
            background-color: transparent;
            border: none !important;
            height: 100% !important;
            width: 100% !important;
            margin: auto !important;
            top: auto !important;
            left: auto !important;
            background-size: auto 20%;
            background-repeat: no-repeat;
            background-position: right 10px center;
        }

        @media screen and (min-width:901px) and (max-width:1600px) {
            .search-select{
                font-size: 11px !important;
                padding-left: 0px !important;
            }
            .select2-container{
                max-width: 75% !important;
            }
            .select2-container--default .select2-selection--single .select2-selection__rendered{
                font-size: 13px;
            }
        }
    </style>
@stop

@section('content')

    <main>        
        <section>
            <header>
                {{-- <div class="py-5" style="background-color: rgb(0 0 0 / 82%);">
                    <div class="container py-3 position-relative text_shadow text-white">
                        <div class="row justify-content-center">
                            <div class="col-md-10 col-lg-8 col-xl-6">
                                <h2 class="font-weight-bold h1 section_title">Arama Sonuçları</h2>
                                <h6 class="font-weight-bold text-center">{{ count($properties) }} adet sonuç bulundu.</h6>
                            </div>
                        </div>
                    </div>
                </div> --}}
                @include('search-component.search-component')
            </header>
            <div class="container py-5">                
                <div class="row">
                    @foreach ($properties as $property)
                        @php
                            $post = $property->post;  
                        @endphp
                        @include('new-card.new-card')
                    @endforeach
                </div>
            </div>
        </section>
    </main>

@stop

@section('scripts')
    @parent
    <script>
        $(document).ready(function () {
            $('.money').mask("#.##0", {reverse: true})
            $('.js-select2-cities').select2({
                dropdownAutoWidth : true,
            });
        });        
    </script>
@endsection