@extends('layout.layout')

@section('title', 'Kullanıcı Bilgilerini Düzenle')

@section('styles')
    @parent
    <style>
        .card {
            box-shadow: 0 1px 3px 0 rgba(0,0,0,.1), 0 1px 2px 0 rgba(0,0,0,.06);
        }

        .card {
            position: relative;
            display: flex;
            flex-direction: column;
            min-width: 0;
            word-wrap: break-word;
            background-color: #fff;
            background-clip: border-box;
            border: 0 solid rgba(0,0,0,.125);
            border-radius: .25rem; 
        }

        .card-body {
            flex: 1 1 auto;
            min-height: 1px;
            padding: 1rem;
        }

        .sms-info-i{
            color: rgb(117, 112, 112);
            cursor: pointer;
        }
        .warning-info-box{
            display: none;
            position: absolute;
            width: 172px;
            left: 193px;
            top: -20px;
            z-index: 2;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
        }
        .sms-info-i:hover ~ .warning-info-box{
            display: block !important;
        }
    </style>
@stop

@section('content')

    @include('flash_message.flash')

    <main class="bg-light">        
        <section>
            <header>
                <div class="py-5" style="background-color: rgb(0 0 0 / 82%);">
                    <div class="container py-3 position-relative text_shadow text-white">
                        <div class="row justify-content-center">
                            <div class="col-md-10 col-lg-8 col-xl-6">
                                <h2 class="font-weight-bold h1 section_title">Kullanıcı Bilgilerini Düzenle</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <div class="container py-5" style="display: flex;justify-content: center;">                
                <div class="col-md-8">
                    <div class="card mb-3">
                        <form name="account_form" action="{{ route('user.update', ['slug' => $user->slug]) }}" method="post" enctype="multipart/form-data" style="padding: 25px;">
                            @csrf
                            @method('PUT')
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name">İsim:</label>
                                        <input type="text" name="name" class="form-control" id="name" value="{{ $user->name }}" placeholder="İsim" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="surname">Soyisim:</label>
                                        <input type="text" name="surname" class="form-control" id="surname" value="{{ $user->surname }}" placeholder="Soyisim" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="company_name">Şirket Ünvanı:</label>
                                        <input type="text" name="company_name" class="form-control" placeholder="Şirket Ünvanı" value="{{ $user->company_name }}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="company_tax_office">Şirket Vergi Dairesi:</label>
                                        <input type="text" name="company_tax_office" class="form-control" placeholder="Şirket Vergi Dairesi" value="{{ $user->company_tax_office }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="company_tax_id">Şirket Vergi No:</label>
                                        <input type="text" name="company_tax_id" class="form-control" placeholder="Şirket Vergi No" value="{{ $user->company_tax_id }}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="phone_number">Telefon Numarası:</label>
                                        <input type="text" name="phone_number"  class="form-control" id="phone_number" value="0{{ $user->phone_number }}" aria-describedby="phoneHelp" placeholder="0 (535) 555-55-55" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email">Eposta Adresi:</label>
                                        <input type="email" name="email" class="form-control" id="email" value="{{ $user->email }}" placeholder="Eposta Adresi" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="identity_number">TC Kimlik No:</label>
                                        <input type="text" name="identity_number" class="form-control" id="identity_number" maxlength="11" minlength="11" value="{{ $user->identity_number }}" placeholder="TC Kimlik No">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="sms_permission">Sms Bilgilendirme:</label>
                                        <input type="checkbox" name="sms_permission"   value="1"
                                        @if($user->sms_permission)
                                            checked
                                        @endif
                                        >
                                        <i class="fa fa-question-circle sms-info-i" aria-hidden="true"></i>
                                        <div class="warning-info-box">
                                            <div style="padding: 5px;background:white;border: 1px solid #ddd;">
                                                <p class="mb-0" style="color: black;font-weight:600;font-size:11px;">İhale sürecinde sms üzerinden bilgi almanızı sağlar.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="password">Şifre:</label>
                                        <input type="password" name="password" autocomplete="new-password"  class="form-control" id="password" placeholder="Şifre">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="password-confirm">Şifre Tekrar:</label>
                                        <input type="password" name="password_confirmation" class="form-control" id="password-confirm" placeholder="Şifre Tekrar">
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-block btn-primary py-3">Kaydet</button>
                        </form>
                        @if($errors->any())
                            <div class="mt-2 mb-2">
                                @foreach($errors->all() as $error)
                                    <div class="alert alert-danger" role="alert">
                                        {{ $error }}
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </section>
    </main>

@stop

@section('scripts')
    @parent
    <script type='text/javascript' src="https://rawgit.com/RobinHerbots/jquery.inputmask/3.x/dist/jquery.inputmask.bundle.js"></script>
    <script>
        $(function () {
            $("#phone_number").inputmask({"mask": "9 (999) 999-99-99"});

            $("#identity_number").on({
                keydown: function(e) {
                    if (e.which === 32)
                    return false;
                },
                change: function() {
                    this.value = this.value.replace(/\s/g, "");
                }
            });
        });
    </script>
@endsection