@extends('layout.layout')

@section('title', 'Tekliflerim ve Favorilerim')

@section('styles')
    @parent
    <style>
        .nav-link{
            color: white !important;
            background: rgb(39, 34, 34) !important;
            border-color: rgb(39, 34, 34) !important;
        }
        .export_document{
            text-align: end;
            margin-bottom: 20px;
        }
        .table td{
            vertical-align: middle !important;
        }
        table.table-bordered.dataTable tbody td{
            background-color: white;
            box-shadow: inset 0 0 0 9999px #fff;
            border-bottom: 1px solid black;
        }

        .res-table-img{
            min-width:120px;
            object-fit: cover;
        }

        @media screen and (max-width:900px) {
            .res-table-img{
                min-width:100% !important;
                min-height: 129px;
                object-fit: contain;
            }
        }
    </style>
@stop

@section('content')

    @include('flash_message.flash')
    <!-- start main container -->
    <main class="bg-light">        
        <section>
            <header>
                <div class="py-5" style="background-color: rgb(0 0 0 / 82%);">
                    <div class="container py-3 position-relative text_shadow text-white">
                        <div class="row justify-content-center">
                            <div class="col-md-10 col-lg-8 col-xl-6">
                                <h2 class="font-weight-bold h1 section_title">Tekliflerim ve Favorilerim</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            <div class="container-fluid py-5">                

                <ul class="nav nav-pills mt-3 tab_faq" id="pills-tab" role="tablist">
                    <li class="nav-item border-right border-white overflow-hidden">
                        <a
                            class="nav-link active btn btn-dark font-weight-bold rounded-0"
                            id="tab_default"
                            data-toggle="pill"
                            href="#pending_approval"
                            role="tab"
                            aria-controls="pending_approval"
                            aria-selected="true"
                            >
                            Onay Bekleyen İhalelerim
                        </a>
                    </li>
                    <li class="nav-item border-right border-white overflow-hidden">
                        <a
                            class="nav-link btn btn-dark font-weight-bold rounded-0"
                            id="tab_payment"
                            data-toggle="pill"
                            href="#active_tenders"
                            role="tab"
                            aria-controls="active_tenders"
                            aria-selected="false"
                            >
                            Aktif İhalelerim
                        </a>
                    </li>
                    <li class="nav-item border-right border-white overflow-hidden">
                        <a
                            class="nav-link btn btn-dark font-weight-bold rounded-0"
                            id="tab_documents"
                            data-toggle="pill"
                            href="#completed_tenders"
                            role="tab"
                            aria-controls="completed_tenders"
                            aria-selected="false"
                            >
                            Sonuçlanmış İhalelerim
                        </a>
                    </li>
                    <li class="nav-item border-right border-white overflow-hidden">
                        <a
                            class="nav-link btn btn-dark font-weight-bold rounded-0"
                            id="tab_documents"
                            data-toggle="pill"
                            href="#favorite_tenders"
                            role="tab"
                            aria-controls="favorite_tenders"
                            aria-selected="false"
                            >
                            Favori İhalelerim
                        </a>
                    </li>
                </ul>
                <div class="tab-content border mb-3 bg-light" id="pills-tabContent">
                    {{-- Onay Bekleyen İhalelerim --}}
                    <div class="bg-white px-3 px-xl-4 pt-5 pb-4 clearfix tab-pane fade active show" id="pending_approval" role="tabpanel">
                        <div class="container pb-3" style="min-height: 500px;">
                            <div class="row">
                                @foreach ($userUnverifiedTenders as $post)
                                    
                                        @include('new-card.new-card')
                                    
                                @endforeach
                            </div>
                        </div>
                    </div>
                    {{-- Aktif İhalelerim --}}
                    <div class="bg-white px-3 px-xl-4 pt-5 pb-4 clearfix tab-pane fade" id="active_tenders" role="tabpanel">
                        <div class="container-fluid pb-3" style="min-height: 500px;">
                            <div class="row">

                                <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                                    <thead>
                                        <tr class="text_small">
                                            <th class="text-center">Teklif Durumu</th>
                                            <th class="text-center">Resim</th>
                                            <th class="text-center">Banka</th>
                                            <th class="text-center">Banka İhale Kodu</th>
                                            <th class="text-center">İlan Kodu</th>
                                            <th class="text-center">İlan İsmi</th>
                                            <th class="text-center">İlan Tipi</th>
                                            <th class="text-center">İlan Adresi</th>
                                            <th class="text-center">Durum</th>
                                            <th class="text-center">Verdiğin Tekklifler</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($userContiniousTenders as $post)
                                        
                                            <tr class="text_small" data-href="{{ route('post.show', ['slug' => $post->postable->slug]) }}" style="cursor: pointer;">
                                                
                                                <td class="text-center">
                                                    @php
                                                        $userControl =  in_array($post->id, Auth::user()->offers->pluck('post_id')->toArray());
                                                    @endphp
                                                    @if ($userControl == true)
                                                        @if ($post->winner_id == Auth::user()->id)
                                                            Şuan en yüksek teklif size ait.
                                                        @else
                                                            Bir başka kullanıcı sizden daha yüksek teklif vermiştir.
                                                        @endif
                                                    @else
                                                        Teklif vermediniz.
                                                    @endif
                                                    
                                                </td>
                                                <td class="text-center d-flex align-items-center">
                                                    
                                                    <img class="img-fluid res-table-img"
                                                        @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                            src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}"
                                                        @endif alt="İlan Resmi">
                                                    
                                                </td>
                                                <td class="text-center">{{ $post->bank->name }}</td>
                                                <td class="text-center">{{ $post->code }}</td>
                                                <td class="text-center">{{ $post->tender_code }}</td>
                                                <td class="text-center">{{ $post->title }}</td>                                        
                                                <td class="text-center">{{ config('enums.property_type')[$post->postable->property_type] }}</td>
                                                <td class="text-center">{{ $post->postable->country }} - {{ $post->postable->district }} - {{ $post->postable->neighborhood }}</td>
                                                <td class="text-center">
                                                    @if ($post->diffinseconds)
                                                        <div style="display: inline-block;min-width: 117px;">
                                                            <div id="clockdiv-{{ $post->id }}" class="d-flex" style="grid-gap: 10px;align-items: center;">
                                                                <div style="display: flex;flex-direction: row;align-items: center;">
                                                                    <span class="days" style="font-size: 14px;"></span>
                                                                    <div class="smalltext" style="font-size: 14px;margin-left: 3px;">Gün</div>
                                                                </div>
                                                                <div style="display: flex;flex-direction: row;align-items: center;">
                                                                    <span class="hours" style="font-size: 14px;"></span>
                                                                    <div>:</div>
                                                                    <span class="minutes" style="font-size: 14px;"></span>
                                                                    <div>:</div>
                                                                    <span class="seconds" style="font-size: 14px;"></span>
                                                                </div>
                                                            </div>
                                                            <script>
                                                                var diffInSeconds = {!! $post->diffinseconds !!};
                                                                var postId = {!! $post->id !!};
                                                                function getTimeRemaining(endtime) {
                                                                    var t = Date.parse(endtime) - Date.parse(new Date());
                                                                    var seconds = Math.floor((t / 1000) % 60);
                                                                    var minutes = Math.floor((t / 1000 / 60) % 60);
                                                                    var hours = Math.floor((t / (1000 * 60 * 60)) % 24);
                                                                    var days = Math.floor(t / (1000 * 60 * 60 * 24));
                                                                    return {
                                                                        'total': t,
                                                                        'days': days,
                                                                        'hours': hours,
                                                                        'minutes': minutes,
                                                                        'seconds': seconds
                                                                    };
                                                                }
                                                            
                                                                function initializeClock(id, endtime) {
                                                                    var clock = document.getElementById(id);
                                                                    var daysSpan = clock.querySelector('.days');
                                                                    var hoursSpan = clock.querySelector('.hours');
                                                                    var minutesSpan = clock.querySelector('.minutes');
                                                                    var secondsSpan = clock.querySelector('.seconds');
                                                            
                                                                    function updateClock() {
                                                                        var t = getTimeRemaining(endtime);
                                                            
                                                                        daysSpan.innerHTML = t.days;
                                                                        hoursSpan.innerHTML = ('0' + t.hours).slice(-2);
                                                                        minutesSpan.innerHTML = ('0' + t.minutes).slice(-2);
                                                                        secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);
                                                            
                                                                        if (t.total <= 0) {
                                                                            clearInterval(timeinterval);
                                                                        }
                                                                    }
                                                                    var timeinterval = setInterval(updateClock, 1000);
                                                                    updateClock();
                                                                }
                                                            
                                                                var deadline = new Date(Date.parse(new Date()) + diffInSeconds * 1000);
                                                                initializeClock('clockdiv-'+ postId, deadline);
                                                            </script>
                                                        </div>
                                                    @else
                                                        Teklif Bekleniyor
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    <div style="max-height: 129px;overflow-y: auto;">
                                                        @foreach ($post->offers as $item)
                                                            <div style="border:1px solid #ddd;margin-bottom:5px;">
                                                                @php
                                                                $time = date('d/m/Y H:i:s', strtotime($item->created_at));
                                                                @endphp
                                                                <p class="mb-0" style="font-size: 11px;">{{ $time }} Miktar:{{ number_format($item->price, 0, '.', '.') }}&#x20BA;</p>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                    
                                                </td>
                                                
                                            </tr>
                                        
                                        @endforeach
                                    </tbody>
                                </table>

                                    {{-- @include('new-card.new-card') --}}

                            </div>
                        </div>
                    </div>
                    {{-- Sonuçlanmış İhalelerim --}}
                    <div class="bg-white px-3 px-xl-4 pt-5 pb-4 clearfix tab-pane fade" id="completed_tenders" role="tabpanel">
                        <div class="container-fluid pb-3" style="min-height: 500px;">
                            <div class="row">
                                {{-- {{ dd($userFinishedTenders) }} --}}
                                    <table class="table table-striped table-bordered table-hover dataTables-imobi2 w-100" >
                                        <thead>
                                            <tr class="text_small">
                                                <th class="text-center">Resim</th>
                                                <th class="text-center">Banka</th>
                                                <th class="text-center">Banka İhale Kodu</th>
                                                <th class="text-center">İlan Kodu</th>
                                                <th class="text-center">İlan İsmi</th>
                                                <th class="text-center">İlan Tipi</th>
                                                <th class="text-center">İlan Adresi</th>
                                                <th class="text-center">Durum</th>
                                                <th class="text-center">Verdiğin Tekklifler</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($userFinishedTenders as $post)
                                                <tr class="text_small">
                                                    <td class="text-center">
                                                        <img class="img-fluid res-table-img"
                                                            @if (isset(Storage::allFiles($post->images_folder)[0]))
                                                                src="{{asset('storage/'.Storage::allFiles($post->images_folder)[0] )}}"
                                                            @endif alt="İlan Resmi">
                                                    </td>
                                                    <td class="text-center">{{ $post->bank->name }}</td>
                                                    <td class="text-center">{{ $post->code }}</td>
                                                    <td class="text-center">{{ $post->tender_code }}</td>
                                                    <td class="text-center">{{ $post->title }}</td>                                        
                                                    <td class="text-center">{{ config('enums.property_type')[$post->postable->property_type] }}</td>
                                                    <td class="text-center">{{ $post->postable->country }} - {{ $post->postable->district }} - {{ $post->postable->neighborhood }}</td>
                                                    <td class="text-center">{{ config('enums.tender_status')[$post->tender_status] }}</td>
                                                    <td class="text-center">
                                                        <div style="max-height: 129px;overflow-y: auto;">
                                                            @foreach ($post->offers as $item)
                                                                <div style="border:1px solid #ddd;margin-bottom:5px;">
                                                                    @php
                                                                    $time = date('d/m/Y H:i:s', strtotime($item->created_at));
                                                                    @endphp
                                                                    <p class="mb-0" style="font-size: 11px;">{{ $time }} Miktar:{{ number_format($item->price, 0, '.', '.') }}&#x20BA;</p>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                            </div>
                        </div>
                    </div>
                    {{-- Favori İhalelerim --}}
                    <div class="bg-white px-3 px-xl-4 pt-5 pb-4 clearfix tab-pane fade" id="favorite_tenders" role="tabpanel">
                        <div class="container-fluid pb-3" style="min-height: 500px;">
                            <div class="row">
                                @foreach ($userFavoriteTenders as $post)

                                    @include('new-card.new-card-save')

                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </section>
    </main>
    <!-- end main container -->
@stop

@section('scripts')
    @parent
    <script>
        $( document ).ready(function() {
            $('.money').mask("#.##0", {reverse: true});
        });
    </script>

    <script>
        $(document).ready(function () {
            var isLargerThanMobileScreen = ($(window).width() < 950) ? true : false;

            $('.dataTables-imobi').DataTable({
                "order": [[ 0, "asc" ]],
                // "responsive": isLargerThanMobileScreen,
                "scrollX": isLargerThanMobileScreen,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of MAX records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'Property_Listings',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible',
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'My Properties',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible'
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

            //        $(".dataTables_wrapper").addClass("d-flex justify-content-between flex-wrap");
            $(".btn_datatable").removeClass("btn-secondary").addClass("btn-outline-primary");
            $('.export_document').prependTo('.export_document_box');

            $('.dataTables-imobi2').DataTable({
                "order": [[ 1, "asc" ]],
                "scrollX": isLargerThanMobileScreen,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of MAX records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'Property_Listings',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible',
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'My Properties',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible'
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

            $('tr[data-href]').on("click", function() {
                document.location = $(this).data('href');
            });

        });
    </script>
@endsection