

<?php $__env->startSection('title', 'İlan Düzenle'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .form-control:focus{
            box-shadow: 0 0 0 0rem rgb(0 0 0 / 0%);
        }
        .form-group-border{
            border: 1px solid #e9dbdb;
            padding-bottom: 15px;
        }
        .label-under{
            text-decoration: underline;
            text-decoration-color: #f4eded;
            padding: 5px;
        }
        .ui-list-div{
            display: flex;flex-direction: row;flex-wrap: wrap;padding: 15px;
        }

        input[type="file"] {
            display: block;
        }
        .imageThumb {
            max-height: 175px;
            border:1px solid #ddd;
            padding: 1px;
            cursor: pointer;
            width: 100%;
            object-fit: cover;
        }
        .pip {
            display: inline-block;
            margin: 10px 10px 0 0;
        }
        .remove {
            display: block;
            background: #444;
            border: 1px solid #ddd;
            color: white;
            text-align: center;
            cursor: pointer;
        }
        .remove:hover {
            background: white;
            color: black;
        }
        #url_langitude {
            pointer-events: none;
        }
        #url_longitude{
            pointer-events: none;
        }
        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:7px;
        }
        
        .text-currency{
            padding:10px 20px;
            border:solid 1px #ccc;
            border-radius:5px;
        }
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.properties.index')); ?>">İlanlar</a></li>
        <li class="breadcrumb-item active" aria-current="page">İlan Düzenle</li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="fas fa-sign"></i>İlan Düzenle</h3>
    </header>
    <div class="d-flex" style="justify-content: flex-end;">
        <a class="btn btn-danger" href="<?php echo e(route('admin.imagePage', ['slug' => $property->slug])); ?>">İlan Resimleri</a>
    </div>
    <div class="py-3">
        <div class="wizard-content bg-white rounded border shadow-sm py-3 py-md-4 py-lg-5 px-3 px-md-4 px-lg-5">
            <form id="wizard_form" action="<?php echo e(route('admin.properties.update', ['property' => $property->slug])); ?>" class="tab-wizard wizard-circle wizard clearfix text-muted" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <h6>Temel</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-laptop-house"></i> Temel:</h4>
                    </header>
                    <div class="py-3">
                        <div class="form-row">
                            <div class="col-md-6 col-lg-7">
                                <div class="form-group">
                                    <label for="property_code">İlan Kodu:</label>
                                    <input class="form-control" value="<?php echo e($property->post->code); ?>" type="text" name="post[code]" id="property_code" placeholder="İlan Kodu" required>
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="property_bank">Banka:</label>
                                        <select class="form-control" name="post[bank_id]" id="bank_select">
                                            <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($bank->id); ?>" <?php echo e($property->post->bank_id == $bank->id ? 'selected' : ''); ?>>
                                                    <?php echo e($bank->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label for="deposit_ratio">Teminat Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="<?php echo e($property->post->bank->deposit); ?>" type="text" id="deposit_ratio" placeholder="Teminat Oranı" required>
                                        </div>                          
                                    </div>
                                </div>
                                
                                <div class="form-group d-flex">
                                    <div class="col-md-12 pl-0">
                                        <label for="deposit_ratio">İhaleye Dahil Edilecek Evraklar:</label>
                                        <div id="contact-container">
                                            <?php $__currentLoopData = $property->post->bank->documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-auto">
                                                    <input class="contracts" type="checkbox" value="<?php echo e($document->id); ?>" name="post[contracts][]"
                                                    <?php if($property->post->contracts != null): ?>
                                                        <?php if(in_array($document->id, $property->post->contracts)): ?>
                                                            checked
                                                        <?php endif; ?>   
                                                    <?php endif; ?>
                                                    >
                                                    <span style="margin-right: 15px;"><?php echo e($document->contract_name); ?></span>
                                                </div>                                                
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $propturkContracts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-auto">
                                                    <input class="contracts" type="checkbox" value="<?php echo e($document->id); ?>" name="post[contracts][]"
                                                    <?php if($property->post->contracts != null): ?>
                                                        <?php if(in_array($document->id, $property->post->contracts)): ?>
                                                            checked
                                                        <?php endif; ?>   
                                                    <?php endif; ?>
                                                    >
                                                    <span style="margin-right: 15px;"><?php echo e($document->contract_name); ?></span>
                                                </div>                                                
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="property_type">Emlak Tipi</label>
                                    <div>
                                        <input class="properties-type-input" type="radio" value="0" 
                                        <?php if($property->property_type == 0): ?>
                                            checked
                                        <?php endif; ?>
                                        disabled
                                        name="properties[property_type]">
                                        <span style="margin-right: 15px;">Konut</span>
                                        <input class="properties-type-input" type="radio" value="1"
                                        <?php if($property->property_type == 1): ?>
                                            checked
                                        <?php endif; ?>
                                        disabled
                                        name="properties[property_type]">
                                        <span style="margin-right: 15px;">İş Yeri</span>
                                        <input class="properties-type-input" type="radio" value="2" 
                                        <?php if($property->property_type == 2): ?>
                                            checked
                                        <?php endif; ?>
                                        disabled
                                        name="properties[property_type]">
                                        <span>Arsa</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="property_title">İlan Başlığı:</label>
                                    <input class="form-control"  value="<?php echo e($property->post->title); ?>" type="text" name="post[title]" id="property_title"  placeholder="İlan Başlığı" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-12 col-md-7">
                                <div class="form-group">
                                    <label for="property_desc">Açıklama:</label>                                      
                                    <textarea class="form-control summernote border" name="post[desc]" id="property_desc" rows="5"><?php echo e($property->post->desc); ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6 col-lg-7">
                                <div class="form-group">
                                    <label for="is_opportunity">Fırsat Butonu:</label>                                      
                                    <input type="checkbox" name="post[is_opportunity]" value="0">
                                </div>
                                <div class="form-group">
                                    <label for="duration">İlan Süresi:</label>
                                    <div class="d-flex">
                                        <div class="w-100">
                                            <label for="duration_day" style="font-size: 12px;text-decoration: underline;">Gün</label>
                                            <input class="form-control" value="<?php echo e($postDay); ?>" type="number" name="post[duration_day]" id="duration_day" min="0" placeholder="İlan Süresi(Gün)" required>
                                        </div>
                                        <div class="w-100" style="margin-left: 30px;">
                                            <label for="duration_hour" style="font-size: 12px;text-decoration: underline;">Saat</label>
                                            <input class="form-control" value="<?php echo e($postHour); ?>" type="number" name="post[duration_hour]" id="duration_hour" min="0" max="23" placeholder="İlan Süresi(Saat)" required>
                                        </div>
                                    </div>                                   
                                </div>
                                <div class="form-group">
                                    <label for="start_price">Başlangıç Bedeli:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="<?php echo e($property->post->start_price); ?>" type="text" name="post[start_price]" id="start_price" placeholder="Başlangıç Bedeli" required>
                                    </div>                                  
                                    
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="offer_step">Teklif Adımı:</label>  
                                        <div class="currency-wrap">
                                            <span class="currency-code">&#x20BA;</span>
                                            <input class="form-control money text-currency" value="<?php echo e($property->post->offer_step); ?>" type="text" name="post[offer_step]" id="offer_step" placeholder="Teklif Adımı" required>
                                        </div>                                     
                                        
                                    </div>
                                    <div class="col-md-6 pr-0">
                                        <label for="offer_ratio">Teklif Adım Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="1" min="0" minlength="0.5" maxlength="100" step="0.5" type="number" id="offer_ratio" placeholder="Teminat Oranı">
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="form-group">
                                    <label for="is_warrant">Teminatı PropTürk Tutacak?:</label>                                      
                                    <select class="form-control" name="post[is_warrant]" id="is_warrant">
                                        <option
                                        value="0"
                                        <?php if($property->post->is_warrant == 0): ?>
                                            selected
                                        <?php endif; ?>>Hayır</option>
                                        <option  
                                        value="1"
                                        <?php if($property->post->is_warrant == 1): ?>
                                            
                                            selected
                                        <?php endif; ?>>Evet</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="entry_price">Banka İhale Teminat Bedeli:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="<?php echo e($property->post->entry_price); ?>" type="text" name="post[entry_price]" id="entry_price" placeholder="İhale Katılım Bedeli" required>
                                    </div>                                     
                                    
                                </div>
                                <div class="form-group d-flex">
                                    <div class="col-md-6 pl-0">
                                        <label for="entry_price">PropTürk İhale Katılım Bedeli:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">&#x20BA;</span>
                                            <input class="form-control money text-currency" value="<?php echo e($property->post->deposit_ratio); ?>" type="text" name="post[deposit_ratio]" id="propturk_deposit" placeholder="İhale Katılım Bedeli" required>
                                        </div>                                         
                                    </div>
                                    <div class="col-md-6 pl-0">
                                        <label for="offer_ratio_propturk">Proptürk İhale Katılım Oranı:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency" value="" min="0" minlength="0.5" maxlength="100" step="1" type="number" id="offer_ratio_propturk" placeholder=" Propturk Teminat Oranı">
                                        </div>
                                    </div>
                                </div> 
                                <div class="form-group">
                                    <label for="is_fast_buy">Hemen Al Açık?:</label>                                      
                                    <select class="form-control" name="post[is_fast_buy]" id="is_fast_buy">
                                        <option
                                        <?php if($property->post->is_fast_buy == 0): ?>
                                            selected
                                        <?php endif; ?>
                                        value="0"
                                        >Hayır</option>
                                        <option  
                                        <?php if($property->post->is_fast_buy == 1): ?>
                                            selected
                                        <?php endif; ?> value="1">Evet</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="fast_buy_price">Hemen Al Fiyatı:</label>
                                    <div class="currency-wrap">
                                        <span class="currency-code">&#x20BA;</span>
                                        <input class="form-control money text-currency" value="<?php echo e($property->post->fast_buy_price); ?>" type="text" name="post[fast_buy_price]" id="fast_buy_price" placeholder="Hemen Al Fiyatı" disabled>
                                    </div>                                        
                                    
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </section>

                <h6>Detay</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-tags"></i> Detay:</h4>
                    </header>
                    
                    <?php if($property->property_type == 0): ?>
                        <?php echo $__env->make('admin.properties.properties_edit.properties1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <?php if($property->property_type == 1): ?>
                        <?php echo $__env->make('admin.properties.properties_edit.properties2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <?php if($property->property_type == 2): ?>
                        <?php echo $__env->make('admin.properties.properties_edit.properties3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </section>

                <h6>Adres</h6>
                <section class="content_address">
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-street-view"></i> Adres:</h4>
                    </header>
                    <div class="form-row">
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="country">İl:</label>
                                <select class="js-select2-city" name="properties[country]">
                                    <option></option>
                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                        <?php if($property->city_id == $city->id): ?>
                                            value="<?php echo e($city->id); ?>"
                                            selected
                                        <?php endif; ?>
                                        value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="district">İlçe:</label>
                                <select class="js-select2-district" name="properties[district]" id="property_district">
                                    <?php if(isset($districts)): ?>
                                        <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option 
                                            <?php if($neighborhood->district_id == $district->id): ?>
                                                value="<?php echo e($district->id); ?>"
                                                selected
                                            <?php endif; ?>
                                            value="<?php echo e($district->id); ?>"
                                            ><?php echo e($district->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12">
                            <div class="form-group">
                                <label for="property_complement">Semt/Mahalle:</label>
                                <select class="js-select2-neighborhood" name="properties[neighborhood]" id="property_neighborhood">
                                    <?php if(isset($neighborhoods)): ?>
                                        <?php $__currentLoopData = $neighborhoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option 
                                            <?php if($neighborhood->id == $item->id): ?>
                                                value="<?php echo e($item->id); ?>"
                                                selected
                                            <?php endif; ?>
                                            value="<?php echo e($item->id); ?>"
                                            ><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="city_block_no">Ada No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->city_block_no); ?>" name="properties[city_block_no]" id="city_block_no">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="parcel_no">Parsel No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->parcel_no); ?>" name="properties[parcel_no]" id="parcel_no">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="floor_no">Kat No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->floor_no); ?>" name="properties[floor_no]">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="block_no">Blok No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->block_no); ?>" name="properties[block_no]">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="independent_section_no">Bağımsız Bölüm No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->independent_section_no); ?>" name="properties[independent_section_no]" id="independent_section_no">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="city_block_no">Ada No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->city_block_no); ?>" name="properties[city_block_no]" id="city_block_no">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="parcel_no">Parsel No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->parcel_no); ?>" name="properties[parcel_no]" id="parcel_no">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="independent_section_no">Bağımsız Bölüm No</label>
                                <input type="text" class="form-control" value="<?php echo e($property->independent_section_no); ?>" name="properties[independent_section_no]" id="independent_section_no">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="parsel_request_url">Parsel Sorgu Url</label>
                                <input type="text" class="form-control" name="properties[parsel_request_url]" value="<?php echo e($property->parsel_request_url); ?>" id="parsel_request_url">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="langitude">Enlem</label>
                                <input type="text" class="form-control" value="<?php echo e($property->langitude); ?>" name="properties[langitude]" id="url_langitude">
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-4">
                            <div class="form-group">
                                <label for="longitude">Boylam</label>
                                <input type="text" class="form-control" value="<?php echo e($property->longitude); ?>" name="properties[longitude]" id="url_longitude">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-8">
                            <div id="map" style="width: 100%; height: 500px;"></div>
                        </div>
                    </div>
                </section>
                
                

                <h6>Yayın</h6>
                <section>
                    <header class="border-bottom border-primary my-4">
                        <h4 class="font-weight-light text-primary"><i class="fas fa-sign"></i> Yayın:</h4>
                    </header>
                    <div class="py-3">
                        <div class="text-center pt-5">
                            <button type="submit" class="btn btn-lg btn-primary slow_3s position-relative px-4 mb-1">
                                Kaydet
                            </button>
                        </div>
                    </div>
                </section>
            </form>
        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/step_wizard/jquery.steps.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/step_wizard/wizard_step_init.js')); ?>"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
    <!-- Datepicker -->
    <script src="<?php echo e(asset('assets/plugins/datepicker/datepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datepicker/datepicker.en-US.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    <?php if(isset($property->longitude)): ?>
        <script>
            $(document).ready(function () {

                var lantg = <?php echo $property->longitude; ?>;
                var lontg = <?php echo $property->langitude; ?>;

                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            });
        </script>
    <?php endif; ?>
    <script>
        $(document).ready(function () {

            var steps = $('.steps').find('li.disabled');
            steps.attr('class', 'done');

            $('#parsel_request_url').change(function(){
                console.log('sa');
                var url = $('#parsel_request_url').val();
                url_lang = url.split('/')[5];
                $('#url_langitude').val(url_lang);
                url_long = url.split('/')[6];
                $('#url_longitude').val(url_long);

                var lantg = url_long;
                var lontg = url_lang;
            
                mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
                const map = new mapboxgl.Map({
                    container: 'map', // container ID
                    style: 'mapbox://styles/mapbox/streets-v11', // style URL
                    center: [lantg, lontg], // starting position [lng, lat]
                    zoom: 15 // starting zoom
                });
                const marker = new mapboxgl.Marker()
                .setLngLat([lantg, lontg])
                .addTo(map);
            });
            // $("#parsel_request_url").bind("paste", function(e){
            //     var url = $('#parsel_request_url').val();
            //     url_lang = url.split('/')[5];
            //     $('#url_langitude').val(url_lang);
            //     url_long = url.split('/')[6];
            //     $('#url_longitude').val(url_long);
            // });
        });
    </script>
    <script>
        // is_fast_buy
        $(document).ready(function () {
            
            var s = $('#is_fast_buy').val();
            if (s == 1) {
                    $('#fast_buy_price').prop( "disabled", false );
                }
            if (s == 0) {
                $('#fast_buy_price').prop( "disabled", true );
            }
            $('#is_fast_buy').change(function() {
                var c = $(this).val();
                console.log(c);
                if (c == 1) {
                    $('#fast_buy_price').prop( "disabled", false );
                }
                if (c == 0) {
                    $('#fast_buy_price').prop( "disabled", true );
                }
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.js-select2-city').select2({
                dropdownAutoWidth : true,
                width: 'auto',
                placeholder: "Lütfen Şehir Seçiniz",
            });

            // var $a = $('.js-select2-distirct');
            // .select2({
            //     dropdownAutoWidth : true,
            //     width: 'auto'
            // });

            $('.js-select2-city').on('select2:select', function (e) {
                var data = e.params.data;
                console.log(data.id);

                var cityId = data.id;
                $.ajax({
                    type:'GET',
                    url: "<?php echo route('address.getDistricts', ''); ?>" + "/" + cityId,
                    success:function(data){
                        $('.js-select2-district').empty().select2({
                            dropdownAutoWidth : true,
                            width: 'auto',
                            placeholder: "Lütfen İlçe Seçiniz",
                            data: data
                        });
                        $('.js-select2-district').val(1).trigger('change.select2');
                    }
                });
            });

            $('.js-select2-district').on('select2:select', function (e) {
                var data = e.params.data;
                console.log(data.id);

                var cityId = data.id;
                $.ajax({
                    type:'GET',
                    url: "<?php echo route('address.getNeighborhoods', ''); ?>" + "/" + cityId,
                    success:function(data){
                        $('.js-select2-neighborhood').empty().select2({
                            dropdownAutoWidth : true,
                            width: 'auto',
                            placeholder: "Lütfen Mahalle Seçiniz",
                            data: data
                        });
                        $('.js-select2-neighborhood').val(1).trigger('change.select2');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $('.j_datepicker').datepicker({
                language: 'en-US',
                autoClose: true
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            
            if (window.File && window.FileList && window.FileReader) {
                $(".remove").click(function(){
                    $(this).parent(".pip").remove();
                });
                $("#files").on("change", function(e) {
                var files = e.target.files,
                    filesLength = files.length;
                for (var i = 0; i < filesLength; i++) {
                    var f = files[i]
                    var fileReader = new FileReader();
                    fileReader.onload = (function(e) {
                    var file = e.target;
                    $("<span class=\"pip\">" +
                        "<img class=\"imageThumb\" src=\"" + e.target.result + "\" title=\"" + file.name + "\"/>" +
                        "<br/><span class=\"remove\">Resmi Sil</span>" +
                        "</span>").insertAfter("#files");
                    $(".remove").click(function(){
                        $(this).parent(".pip").remove();
                    });
                    
                    });
                    fileReader.readAsDataURL(f);
                }
                });
            } else {
                alert("Your browser doesn't support to File API")
            }
        });
    </script>

    <!-- Summernote https://summernote.org/-->
    <script src="<?php echo e(asset('assets/plugins/summernote/summernote.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('.summernote').summernote({
                placeholder: 'Açıklama',
                tabsize: 2,
                height: 140,
                focus: false,
                toolbar: [
                    ['font', ['bold', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']]
                ]
            });
            
        });
    </script>

    <script>
        $(function () {
            $('.money').mask("#.##0", {reverse: true});
            $(".formDate").mask("99/99/99");
            $(".formTime").mask("99/99/99 99:99");
            // $(".formCurrency").mask('#.###.###', {reverse: true});

            $("input[type='tel']").focusout(function () {
                var phone, element;
                element = $(this);
                element.unmask();
                phone = element.val().replace(/\D/g, '');
                if (phone.length > 10) {
                    element.mask("(99) 99999-9999");
                } else {
                    element.mask("(99) 9999-99999");
                }
            }).trigger('focusout');

        });
    </script>

    <script>
        $(document).ready(function() {
            
            // $('input[name="properties[property_type]"').change(function() {
            //     console.log('sa');
            // });


            $('input[name="properties[property_type]"').change(function() {
                
                var inputVal = $("input[name='properties[property_type]']:checked").val();
                $.ajax({
                    type:'GET',
                    url: "<?php echo route('admin.ajaxInput', ''); ?>" + "/" + inputVal,
                    success:function(data){
                        console.log(data.html);
                        $('#ajaxProperties').append(data.html);
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {
            $("#bank_select").on('change', function() {
                var bankId =  $(this).val();
                var banksWithDocuments = <?php echo json_encode($banksJsonFormat, 15, 512) ?>;
                $('#contact-container').empty();
                $.each(banksWithDocuments, function (indexInArray, bank) { 
                    if(bank.id == bankId && bank.name != 'propturk') {
                        bank.documents.forEach(element => {
                            $("#contact-container").append(
                                '<div class="col-auto">'+
                                    '<input class="contracts" type="checkbox" value="'+element.id+'" name="post[contracts][]">'+
                                    '<span style="margin-right: 15px;">'+element.contract_name+'</span>'+
                                '</div>'
                            );
                        });
                    }
                    if(bank.name == 'propturk') {
                        bank.documents.forEach(element => {
                            $("#contact-container").append(
                                '<div class="col-auto">'+
                                    '<input class="contracts" type="checkbox" value="'+element.id+'" name="post[contracts][]">'+
                                    '<span style="margin-right: 15px;">'+element.contract_name+'</span>'+
                                '</div>'
                            );
                        });
                    }
                });

                $.ajax({
                    url :"<?php echo route('admin.getBankDepositRatio', ''); ?>" + "/" + bankId,
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        "id": bankId
                        },
                    // type: 'post',
                    dataType: 'json',
                    success: function(result)
                    {
                        $('#deposit_ratio').val(result);
                        var startPrice = $('#start_price').val();
                        var startPrice = startPrice.split('.').join("");
                        var depositRatio = $('#deposit_ratio').val();
                        var depositRatio = depositRatio.split('.').join("");
                        var process = Math.ceil(startPrice * (depositRatio / 100));
                        var process1 = process.toString();
                        var process2 = process1.match(/\d{1,3}(?=(\d{3})*$)/g);
                        var process3 = process2.join(".");
                        $('#entry_price').val(process3);
                    },
                    error: function()
                    {
                        
                    }
                });
            });

            $('#start_price').change(function() {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var depositRatio = $('#deposit_ratio').val();
                var depositRatio = depositRatio.split('.').join("");
                var entryPrice = Math.ceil(startPrice * (depositRatio / 100));
                var entryPriceProcess = entryPrice.toString();
                var entryPriceProcess = entryPriceProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var entryPriceProcess = entryPriceProcess.join(".");
            
                $('#entry_price').val(entryPriceProcess);

                var offerRatio = $('#offer_ratio').val();
                console.log(offerRatio);
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#offer_step').val(offerStepProcess);

                var propturk_deposit_ratio = $('#offer_ratio_propturk').val();
                var propturk_deposit = Math.ceil(startPrice * (propturk_deposit_ratio / 100));
                var propturkDepositProcess = propturk_deposit.toString();
                var propturkDepositProcess = propturkDepositProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var propturkDepositProcess = propturkDepositProcess.join(".");
                $('#propturk_deposit').val(propturkDepositProcess);
            });

            $('#offer_ratio_propturk').change(function () {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var offerRatio = $('#offer_ratio_propturk').val();
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#propturk_deposit').val(offerStepProcess);
            });

            $('#deposit_ratio').change(function() {

                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var depositRatio = $('#deposit_ratio').val();
                var depositRatio = depositRatio.split('.').join("");
                var process = Math.ceil(startPrice * (depositRatio / 100));
                var process1 = process.toString();
                var process2 = process1.match(/\d{1,3}(?=(\d{3})*$)/g);
                var process3 = process2.join(".");

                $('#entry_price').val(process3);
            });

            $('#offer_ratio').change(function () {
                var startPrice = $('#start_price').val();
                var startPrice = startPrice.split('.').join("");
                var offerRatio = $('#offer_ratio').val();
                var offerStep = Math.ceil(startPrice * (offerRatio / 100));
                var offerStepProcess = offerStep.toString();
                var offerStepProcess = offerStepProcess.match(/\d{1,3}(?=(\d{3})*$)/g);
                var offerStepProcess = offerStepProcess.join(".");

                $('#offer_step').val(offerStepProcess);
            });

            // $('#propturk_deposit').change(function () {
            //     var propturk_deposit_ratio = 0.0472;
            //     var startPrice = $('#start_price').val();
            //     var startPrice = startPrice.split('.').join("");
            //     var propturk_deposit = Math.ceil(startPrice * propturk_deposit_ratio);
            //     $('#propturk_deposit').val(propturk_deposit);

            // });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/properties/edit.blade.php ENDPATH**/ ?>