<!DOCTYPE html>
<html lang="zxx">
    <head>
        <meta charset="UTF-8"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="robots" content="noindex, nofollow"/>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <link href="<?php echo e(asset('assets/img/favicon.png')); ?>" rel="shortcut icon"/>

        <title><?php echo $__env->yieldContent('title'); ?></title>

        <?php echo $__env->make('admin.layout.include-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('styles'); ?>
        <style>
            #loader {
                border: 12px solid #f3f3f3;
                border-radius: 50%;
                border-top: 12px solid #444444;
                width: 70px;
                height: 70px;
                animation: spin 1s linear infinite;
            }
            
            @keyframes  spin {
                100% {
                    transform: rotate(360deg);
                }
            }
            
            .loader-center {
                position: absolute;
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
                margin: auto;
            }

            .ui-hover-a a:hover{
                background-color: #ebeafc !important;
            }
            /* Chrome, Safari, Edge, Opera */
            /* input::-webkit-outer-spin-button,
            input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
            } */
            
            input[type=number] {
            -moz-appearance: textfield;
            }
        </style>
        <!--[if lt IE 9]><script src="assets/html5shiv.min.js"></script><![endif]-->
    </head>
    <body class="bg-light dashbord_content">
        <div id="loader" class="loader-center"></div>
        <div class="position-relative wrapper_content clearfix d-block float-left w-100">
            <nav class="navbar navbar-expand-md bg_theme navbar-dark" style="background: black !important;">
                <div class="container">
                    <a class="navbar-brand" href="<?php echo e(route('home')); ?>"><img style="width: 250px;" src="<?php echo e(asset('assets/img/logo-footer.png')); ?>" title="markest.com.tr" alt="markest"/></a>
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Open Navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ml-auto">
                            <li class="nav-item active">
                                <a class="nav-link" href="<?php echo e(route('admin.home')); ?>">Anasayfa <span class="sr-only">(current)</span></a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="uiInterfaceDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Hızlı Erişim
                                </a>
                                <div class="dropdown-menu dropdown-menu-right p-0 overflow-hidden ui-hover-a" aria-labelledby="uiInterfaceDropdown">
                                    <a class="dropdown-item py-3" href="<?php echo e(route('admin.properties.index')); ?>">Tüm İlanlar</a>
                                    <a class="dropdown-item py-3" href="<?php echo e(route('admin.users.index')); ?>">Tüm Kullanıcılar</a>
                                    <a class="dropdown-item py-3" href="<?php echo e(route('admin.banks.index')); ?>">Tüm Bankalar</a>
                                    <a class="dropdown-item py-3" href="<?php echo e(route('admin.logs')); ?>">Log Kayıtları</a>                                  
                                </div>
                            </li>
                            
                            
                            <li class="nav-item dropdown ">
                                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Merhaba <b><?php echo e(Auth::user()->name); ?></b>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right overflow-hidden p-0 overflow-hidden" aria-labelledby="navbarDropdown">
                                    <div class="dropdown-item disabled bg-info py-3 text-center text-white d-block px-lg-5">
                                        <h5 class="mb-0 mt-2">Admin Paneli</h5>
                                        <small>Super Admin (adm)</small>
                                    </div>
                                    
                                    
                                    
                                    <?php if(auth()->user()->id == 1): ?>
                                        <a class="dropdown-item py-3" href="<?php echo e(route('admin.users.edit', ['user' => auth()->user()->id])); ?>" title="Bilgileri Düzenle">
                                            <i class="fas fa-sign-out-alt"></i> Bilgileri Düzenle
                                        </a>
                                    <?php endif; ?>
                                    <a class="dropdown-item py-3" href="<?php echo e(route('logout')); ?>" title="Çıkış" onclick="event.preventDefault();
                                    document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt"></i> Çıkış Yap
                                    </a>
                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>

            <!-- START MAIN CONTAINER -->
            <div class="container py-3">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <!-- END MAIN CONTAINER -->

            <footer class="border-top text-center bg-white text-dark d-block w-100 py-3 main_footer position-absolute text_small">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-6 text-center text-md-left">
                            <b  class="text-primary">Markest</b> - Admin Panel <a href='#' title='' ></a>                        
                        </div>
                        <div class="col-sm-6 text-center text-md-right">
                            <b>Version: </b>1.0
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </body>
    <?php echo $__env->make('admin.layout.include-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        document.onreadystatechange = function() {
            if (document.readyState !== "complete") {
                document.querySelector("body").style.visibility = "hidden";
                document.querySelector("#loader").style.visibility = "visible";
            } else {
                document.querySelector("#loader").style.display = "none";
                document.querySelector("body").style.visibility = "visible";
            }
        };
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</html>
<?php /**PATH /var/www/html/propturk/resources/views/admin/layout/layout.blade.php ENDPATH**/ ?>