

<?php $__env->startSection('title', 'İlanlar'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <style>
        .settings-item{
            display: flex;
            flex-direction: row;
            align-items: center;
            height: 48px;
        }
        .settings-item:hover{
            background: #a9a9a982 !important;
        }
        .modal.fade {
            z-index: 10000000 !important;
        }
        .export_document{
            text-align: end;
            margin-bottom: 15px;
        }
        .btn_datatable{
            background: transparent !important;
            border-color: #007bff !important;
            color: #007bff !important;
        }
        .btn_datatable:hover{
            background-color: transparent !important;
            opacity: 0.5 !important;
        }
        .btn-outline-primary:hover, .btn-outline-primary:active{
            background-color: transparent !important;
            opacity: 0.5 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item active" aria-current="page">İlanlar</li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <?php echo $__env->make('flash_message.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <header class="border-bottom mt-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-list-alt"></i> Tüm İlanlar</h3>
        <a class="btn btn-danger" href="<?php echo e(route('admin.properties.create')); ?>" style="margin-bottom: 7px;">İlan Ekle</a>
    </header>
    
    <div class="d-block w-100 pb-2 export_document_box text-center text-md-right mt-md-n5 pb-md-4 pt-3 pt-md-0">
    </div>
    <div class="py-3">
        <div class="">
            <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                <thead>
                    <tr class="text_small">
                        <th>İlan Kodu</th>
                        <th>Banka</th>
                        <th>Emlak Tipi</th>
                        <th>Emlak Alt Tipi</th>                  
                        <th>İlan Başlığı</th>
                        <th>İl</th>
                        <th>İlçe</th>
                        <th>Durum</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($property->post->tender_status != 2): ?>
                            <tr class="text-muted text_small">
                                <td class="text_small">
                                    
                                        <?php echo e($property->post->code); ?>

                                    
                                </td>
                                <td>
                                    
                                        <?php echo e($property->post->bank->name); ?>

                                    
                                </td>
                                <td><?php echo e(config('enums.property_type')[$property->property_type]); ?></td>
                                <td>
                                    <?php if(isset($property->house_type)): ?>
                                        <?php echo e(config('enums.house_type')[$property->house_type]); ?>

                                    <?php endif; ?>
                                    <?php if(isset($property->workplace_type)): ?>
                                        <?php echo e(config('enums.workplace_type')[$property->workplace_type]); ?>

                                    <?php endif; ?>
                                    <?php if(isset($property->land_type)): ?>
                                        <?php echo e(config('enums.land_type')[$property->land_type]); ?>

                                    <?php endif; ?>
                                    
                                </td>                                        
                                <td class="text_small">
                                    <?php if(isset($property->post->title)): ?>
                                        <?php echo e($property->post->title); ?>

                                    <?php endif; ?>
                                    
                                </td>
                                <td class="text-center"><?php echo e($property->country); ?></td>
                                <td class="text-center"><?php echo e($property->district); ?></td>
                                <td class="text-center">
                                    <?php echo e(config('enums.tender_status')[$property->post->tender_status]); ?>

                                </td>
                                <td>
                                    
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="settingsMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            İşlemler <i class="fa fa-cog" aria-hidden="true"></i>
                                        </button>
                                        <div class="dropdown-menu p-0" aria-labelledby="settingsMenuButton" style="border-radius: 0px;">
                                          <a class="dropdown-item settings-item" href="<?php echo e(route('admin.properties.show', ['slug' => $property->slug])); ?>">İlanı Gör</a>
                                          <a class="dropdown-item settings-item" href="<?php echo e(route('admin.properties.edit', ['property' => $property->slug])); ?>">İlanı Düzenle</a>
                                          <a class="dropdown-item settings-item" href="<?php echo e(route('admin.getTenderReportPdf', ['id' => $property->id])); ?>">Rapor İndir</a>
                                          <a class="dropdown-item settings-item" href="<?php echo e(route('admin.archiveFiles.index', ['slug' => $property->slug])); ?>">Arşive Dosya Ekle</a>
                                          
                                        <?php if($property->post->tender_status == 0): ?>
                                            <button type="button" class="dropdown-item settings-item count-modal" data-toggle="modal" data-target="#duplicateModal" id=<?php echo e($property->id); ?>>
                                                İlanı Çoğalt
                                            </button>    
                                            <a class="dropdown-item settings-item" href="<?php echo e(route('admin.setTenderStatusActive', ['id' => $property->post->id])); ?>">İlanı Aktif Et</a>
                                            <?php if(Auth::user()->is_admin == 1): ?>
                                                <form method="POST" action="<?php echo e(route('admin.properties.destroy', ['property' => $property->slug])); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="dropdown-item settings-item" style="color: red">Sil</button>
                                                </form>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php if($property->post->tender_status == 1): ?>
                                            <?php if($property->post->winner_id == NULL): ?>
                                                <a class="dropdown-item settings-item" href="<?php echo e(route('admin.setTenderStatusPassive', ['id' => $property->post->id])); ?>">İlanı Pasif Yap</a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>

        <div class="" style="border-top: 1px solid #dee2e6!important;padding-top:25px;margin-top:55px;">
            <h2>İhalesi Tamamlananlar</h2>
            <table class="table table-striped table-bordered table-hover dataTables-finished w-100" >
                <thead>
                    <tr class="text_small">
                        <th>İlan Kodu</th>
                        <th>Banka</th>
                        <th>Emlak Tipi</th>
                        <th>Emlak Alt Tipi</th>                  
                        <th>İlan Başlığı</th>
                        <th>İl</th>
                        <th>İlçe</th>
                        <th>Durum</th>
                        <th>İşlem</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($property->post->tender_status == 2): ?>
                            <tr class="text-muted text_small">
                                <td class="text_small">
                                    
                                    <?php echo e($property->post->code); ?>

                                    
                                </td>
                                <td>
                                    
                                    <?php echo e($property->post->bank->name); ?>

                                    
                                </td>
                                <td><?php echo e(config('enums.property_type')[$property->property_type]); ?></td>
                                <td>
                                    <?php if(isset($property->house_type)): ?>
                                        <?php echo e(config('enums.house_type')[$property->house_type]); ?>

                                    <?php endif; ?>
                                    <?php if(isset($property->workplace_type)): ?>
                                        <?php echo e(config('enums.workplace_type')[$property->workplace_type]); ?>

                                    <?php endif; ?>
                                    <?php if(isset($property->land_type)): ?>
                                        <?php echo e(config('enums.land_type')[$property->land_type]); ?>

                                    <?php endif; ?>
                                    
                                </td>                                        
                                <td class="text_small">
                                    <?php if(isset($property->post->title)): ?>
                                        <?php echo e($property->post->title); ?>

                                    <?php endif; ?>
                                    
                                </td>
                                <td class="text-center"><?php echo e($property->country); ?></td>
                                <td class="text-center"><?php echo e($property->district); ?></td>
                                <td class="text-center">
                                    <?php echo e(config('enums.tender_status')[$property->post->tender_status]); ?>

                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-secondary dropdown-toggle w-100" type="button" id="settingsMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            İşlemler <i class="fa fa-cog" aria-hidden="true"></i>
                                        </button>
                                        <div class="dropdown-menu p-0" aria-labelledby="settingsMenuButton" style="border-radius: 0px;">
                                            <a class="dropdown-item settings-item" href="<?php echo e(route('admin.properties.show', ['slug' => $property->slug])); ?>">İlanı Gör</a>
                                            <a class="dropdown-item settings-item" href="<?php echo e(route('admin.getTenderReportPdf', ['id' => $property->id])); ?>">Rapor İndir</a>
                                            <a class="dropdown-item settings-item" href="<?php echo e(route('admin.archiveFiles.index', ['slug' => $property->slug])); ?>">Arşive Dosya Ekle</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

</section>

<!-- Modal -->
<div class="modal fade" id="duplicateModal" tabindex="-1" role="dialog" aria-labelledby="duplicateModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="duplicateModalLabel">İlanı Çoğalt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" method="post" id="_tenderForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-row" style="display: flex;justify-content: center;">
                        <div class="col-md-8" style="display: flex;flex-direction: column;align-items: center;">
                            <label for="tender_count">Bu ilanı kaç kere çoğaltmak istiyorsunuz?</label>
                            <input type="number" class="form-control" name="tender_count" id="_tenderCount" value="0" step="1" min="0" style="width: 150px;border-radius:0;" />
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="_saveTenderCount">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    
    <script>

        $(document).ready(function () {
            $(".count-modal").click(function() {
                var modalId = $(this).attr('id');
                console.log(modalId);
                var url = "<?php echo e(route('admin.properties.clone', '')); ?>"+"/"+modalId+"";
                $('#_tenderForm').attr('action', url);
            });

            $('.dataTables-imobi').DataTable({
                responsive: true,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "_TOTAL_ kayıttan _START_ ile _END_ arası kadar gösteriliyor",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of _MAX_ records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ bir sayfada gözüken veri sayısı",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'Devam_Eden_ihaleler_CSV',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'Devam_Eden_ihaleler_Excel',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'Devam_Eden_ihaleler_PDF',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'Devam Eden İhaleler',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

            //        $(".dataTables_wrapper").addClass("d-flex justify-content-between flex-wrap");
            $(".btn_datatable").removeClass("btn-secondary").addClass("btn-outline-primary");
            $('.export_document').prependTo('.export_document_box');

            $('.dataTables-finished').DataTable({
                responsive: true,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "_TOTAL_ kayıttan _START_ ile _END_ arası kadar gösteriliyor",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of _MAX_ records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ bir sayfada gözüken veri sayısı",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'İhalesi_Tamamlananlar_CSV',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'İhalesi_Tamamlananlar_Excel',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'İhalesi_Tamamlananlar_PDF',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'İhalesi Tamamlananlar',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7],
                                stripHtml: true
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/properties/index.blade.php ENDPATH**/ ?>