

<?php $__env->startSection('title', 'Banka Ekle'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <style>
        .onoffswitch {
            position: relative; width: 55px;
            -webkit-user-select:none; -moz-user-select:none; -ms-user-select: none;
            margin-left: 35px;
            margin-top: 5px;
        }
        .onoffswitch-checkbox {
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }
        .onoffswitch-label {
            display: block; overflow: hidden; cursor: pointer;
            height: 20px; padding: 0; line-height: 20px;
            border: 0px solid #FFFFFF; border-radius: 30px;
            background-color: #9E9E9E;
        }
        .onoffswitch-label:before {
            content: "";
            display: block; width: 30px; margin: -5px;
            background: #FFFFFF;
            position: absolute; top: 0; bottom: 0;
            right: 31px;
            border-radius: 30px;
            box-shadow: 0 6px 12px 0px #757575;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label {
            background-color: #42A5F5;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label, .onoffswitch-checkbox:checked + .onoffswitch-label:before {
        border-color: #42A5F5;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-inner {
            margin-left: 0;
        }
        .onoffswitch-checkbox:checked + .onoffswitch-label:before {
            right: 0px; 
            background-color: #2196F3; 
            box-shadow: 3px 6px 18px 0px rgba(0, 0, 0, 0.2);
        }
        .currency-wrap{
            position:relative;
        }
        
        .currency-code{
            position:absolute;
            left:8px;
            top:7px;
        }
        
        .text-currency{
            padding:10px 30px;
            border:solid 1px #ccc;
            border-radius:5px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.banks.index')); ?>">Bankalar</a></li>
        <li class="breadcrumb-item active">Banka Oluştur</li>
    </ol>
</nav>


<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-id-badge"></i> Banka Oluştur</h3>
    </header>

    <div class="row py-3">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="tab-content" id="pills-tabContent">
                <section class="tab-pane fade show active" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <div class="py-3">
                        <form class="auto_save text-muted" name="user_profile" action="<?php echo e(route('admin.banks.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-row">
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="name">Banka Adı:</label>
                                        <input class="form-control"  value="" type="text" name="name" id="bank-name" placeholder="Banka Adı" >
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="code">Banka Kodu:</label>
                                        <input class="form-control"  value="" type="text" name="code" id="code" placeholder="Banka Kodu" style="background-color: #ccebeb;">
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="branch">Banka Şubesi:</label>
                                        <input class="form-control"  value="" type="text" name="branch" id="branch" placeholder="Banka Şubesi" >
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="branch_no">Banka Şube No:</label>
                                        <input class="form-control"  value="" type="number" name="branch_no" id="branch_no" placeholder="Banka Şube No" >
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="account_no">Banka Hesap No:</label>
                                        <input class="form-control"  value="" type="number" name="account_no" id="account_no" placeholder="Banka Hesap No" >
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="iban">Banka İban No:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">TR</span>
                                            <input class="form-control text-currency"  value="" type="text" maxlength="30" name="iban" id="iban" placeholder="Banka İban No" >
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="deposit">Depozito:</label>
                                        <div class="currency-wrap">
                                            <span class="currency-code">%</span>
                                            <input class="form-control text-currency"  value="" type="number" name="deposit" id="deposit" placeholder="Depozito" >
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-md-12 col-lg-4">
                                    <div class="form-group">
                                        <label for="is_active">Banka Aktif Mi?:</label>
                                        <div class="onoffswitch">
                                            <input type="checkbox" name="is_active" class="onoffswitch-checkbox" id="myonoffswitch" tabindex="0" value="0">
                                            <label class="onoffswitch-label" for="myonoffswitch"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-right pt-4">
                                <button type="submit" class="btn btn-lg btn-danger slow_3s  position-relative px-5">Banka Oluştur
                                    <span class="form_load position-absolute">
                                        <span class="spinner-border text-light" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </span>
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#iban').mask("## #### #### #### #### #### ##", {reverse: true});
            $('.onoffswitch-checkbox').change(function(){
                if ($(this).is(':checked')) {
                    $(this).val(1);
                }
                else {
                    $(this).val(0);
                }
            });

            $('#bank-name').change(function() {
                var bankName = $('#bank-name').val();
                var b = bankName.toString()
                                    .trim()
                                    .toLowerCase().replace(/Ğ/gim, "g")
                                    .replace(/Ü/gim, "u")
                                    .replace(/Ş/gim, "s")
                                    .replace(/I/gim, "i")
                                    .replace(/İ/gim, "i")
                                    .replace(/Ö/gim, "o")
                                    .replace(/Ç/gim, "c")
                                    .replace(/ğ/gim, "g")
                                    .replace(/ü/gim, "u")
                                    .replace(/ş/gim, "s")
                                    .replace(/ı/gim, "i")
                                    .replace(/ö/gim, "o")
                                    .replace(/ç/gim, "c")
                                    .replace(/\s+/g, "")
                                    .replace(/[^\w\-]+/g, "")
                                    .replace(/\-\-+/g, "")
                                    .replace(/^-+/, "")
                                    .replace(/-+$/, "");
                $("#code").val(b);
            });
        }); 
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/banks/create.blade.php ENDPATH**/ ?>