

<?php $__env->startSection('title', 'Evraklar'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item active" aria-current="page">Evraklar</li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <?php echo $__env->make('flash_message.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <header class="border-bottom mt-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-list-alt"></i> Evraklar</h3>
        <a class="btn btn-danger" href="<?php echo e(route('admin.documents.create')); ?>" style="margin-bottom: 7px;">Evrak Ekle</a>
    </header>
    <div class="d-block w-100 pb-2 export_document_box text-center text-md-right mt-md-n5 pb-md-4 pt-3 pt-md-0"></div>
    <div class="py-3">
        <div class="">
            <table class="table table-striped table-bordered table-hover dataTables-imobi w-100" >
                <thead>
                    <tr class="text_small">
                        <th>Evrak Adı</th>
                        <th>Banka Adı</th>
                        <th>Durum</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="text-muted text_small">
                            <td><?php echo e($document->contract_name); ?></td>
                            <td><?php echo e($document->bank->name); ?></td>
                            <td><?php echo e(config('enums.is_active')[$document->is_active]); ?></td>
                            <td>
                                <div class="btn-group w-100" role="group" aria-label="Controls">
                                    <a title='Edit Property' href='<?php echo e(route('admin.documents.edit', ['document' => $document->id])); ?>' class='post_single_center btn btn-sm btn-info'><i class="far fa-edit"></i></a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
            </table>
        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script>
        $(document).ready(function () {
            $('.dataTables-imobi').DataTable({
                responsive: true,
                language: {"sEmptyTable": "Sonuç Bulunamadı",
                    "sInfo": "_TOTAL_ kayıttan _START_ ile _END_ arası kadar gösteriliyor",
                    "sInfoEmpty": "0 kayıttan 0 ile 0 arasında gösteriliyor",
                    "sInfoFiltered": "(Filtrados of _MAX_ records)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ bir sayfada gözüken veri sayısı",
                    "sLoadingRecords": "Bekleyiniz...",
                    "sProcessing": "İşleniyor...",
                    "sZeroRecords": "Sonuç Bulunamadı",
                    "sSearch": "Bul",
                    "oPaginate": {
                        "sNext": "İleri",
                        "sPrevious": "Geri",
                        "sFirst": "İlk",
                        "sLast": "Son"
                    },
                    "oAria": {
                        "sSortAscending": ": Sütunları Artana Göre Sırala",
                        "sSortDescending": ": Sütunları Azalana Göre Sırala"
                    },
                    "select": {
                        "rows": {
                            "_": "Selected %d lines",
                            "0": "No rows selected",
                            "1": "Selected 1 line"
                        }
                    },
                    "buttons": {
                        "copy": "Copy to clipboard",
                        "copyTitle": "Copy successful",
                        "copySuccess": {
                            "1": "One line copied successfully",
                            "_": "%d lines successfully copied"
                        }
                    }},
                dom: "B" +
                        "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                //            lfrtip
                buttons: {
                    dom: {
                        container: {
                            tag: 'div',
                            className: 'export_document'
                                    //                        className: 'd-block w-100 pb-3 text-center text-md-right export_document'
                        },
                        buttonLiner: {
                            tag: null
                        }
                    },

                    buttons: [
                        {
                            extend: 'csv',
                            text: '<i class="fas fa-file-csv"></i> CSV',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'excel',
                            text: '<i class="far fa-file-excel" ></i> Excel',
                            title: 'Property_Listings',
                            className: 'btn_datatable'
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="far fa-file-pdf"></i> PDF',
                            title: 'Property_Listings',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible',
                                stripHtml: true
                            },
                            customize: function (doc, config) {
                                var tableNode;
                                for (i = 0; i < doc.content.length; ++i) {
                                    if (doc.content[i].table !== undefined) {
                                        tableNode = doc.content[i];
                                        break;
                                    }
                                }

                                var rowIndex = 0;
                                var tableColumnCount = tableNode.table.body[rowIndex].length;

                                if (tableColumnCount > 5) {
                                    doc.pageOrientation = 'landscape';
                                }
                            }
                        },
                        {
                            extend: 'print',
                            text: '<i class="fas fa-print"></i> Print',
                            title: 'My Properties',
                            className: 'btn_datatable',
                            exportOptions: {
                                columns: ':visible'
                            },
                            customize: function (win) {
                                $(win.document.body).addClass('white-bg');
                                $(win.document.body).css('font-size', '10px');
                                $(win.document.body).find('table').css('font-size', 'inherit');
                            }
                        }

                    ]
                }

            });

            //        $(".dataTables_wrapper").addClass("d-flex justify-content-between flex-wrap");
            $(".btn_datatable").removeClass("btn-secondary").addClass("btn-outline-primary");
            $('.export_document').prependTo('.export_document_box');

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/documents/index.blade.php ENDPATH**/ ?>