<?php $__env->startSection('title', 'Admin'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section>
    <headerclass="border-bottom my-4">
        <h3 class="text-primary font-weight-light">Öne Çıkan Hizmetler</h3>
    </header>

    <div class="row justify-content-center py-3">

        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-success text-white py-lg-4 px-lg-3" href="<?php echo e(route('admin.properties.index')); ?>" title="Tüm İlanlar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="fas fa-home"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">İlanlar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-secondary text-white py-lg-4 px-lg-3" href="<?php echo e(route('admin.users.index')); ?>" title="Kayıtlı Kullanıcılar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="fa fa-users" aria-hidden="true"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Kullanıcılar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-danger text-white py-lg-4 px-lg-3" href="<?php echo e(route('admin.banks.index')); ?>" title="Kayıtlı Bankalar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="far fa-list-alt"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Bankalar</h4>
            </a>
        </div>
        <div class="col-12 col-md-3 pb-4">
            <a class="btn btn-block btn-warning text-white py-lg-4 px-lg-3" href="<?php echo e(route('admin.documents.index')); ?>" title="Evraklar" style="height: 100%">
                <div class="d-flex justify-content-between">
                    <span class="h1"><i class="far fa-list-alt"></i></span>
                    <i class="fas fa-chevron-right align-self-center"></i>
                </div>
                <h4 class="mt-3 text-left h5">Evraklar</h4>
            </a>
        </div>
        <?php if(Auth::user()->is_admin == 1): ?>
            <div class="col-12 col-md-3 pb-4">
                <a class="btn btn-block btn-info text-white py-lg-4 px-lg-3" href="<?php echo e(route('admin.logs')); ?>" title="Log Kayıtları" style="height: 100%">
                    <div class="d-flex justify-content-between">
                        <span class="h1"><i class="fa fa-book" aria-hidden="true"></i></span>
                        <i class="fas fa-chevron-right align-self-center"></i>
                    </div>
                    <h4 class="mt-3 text-left h5">Log Kayıtları</h4>
                </a>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="pb-5">
    <header class="border-bottom border-primary">
        <h2 class="text-primary h5 font-weight-light"><i class="fas fa-chart-line"></i> En çok ziyaret edilen 5 ilan</h2>
    </header>
    <div class="row py-3">
        <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="col-lg-4 col-sm-6 px-3 mb-5">
                <div class="d-flex align-content-between flex-wrap rounded overflow-hidden bg-white border-bottom border-left border-right pb-3" style="height: 100%;">
                    <div class="w-100">
                        <div class="position-relative">
                            <img class="d-block w-100 img-fluid" 
                            <?php if(isset(Storage::allFiles($post->images_folder)[0])): ?>
                                src="<?php echo e(asset('storage/'.Storage::allFiles($post->images_folder)[0] )); ?>"
                            <?php endif; ?> style="max-height: 275px;min-height: 275px;object-fit: cover;"/>
                            <div class="position-absolute imobi_info p-2" style="cursor: pointer">
                                <span class="badge badge-secondary shadow-sm" style="font-size: 17px;background-color:#1e1e1e" data-toggle="tooltip" title="Görüldü"><i class="far fa-eye mr-1"></i><?php echo e($post->posts_views_count); ?></span>           
                            </div>
                        </div>
                        <div class="w-100 px-3 pt-3">
                            <div>
                                <p class="mb-1"><b class='text-primary' style="font-size: 18px;"><?php echo e(number_format($post->current_price, 0, '.', '.')); ?> ₺</b></p>
                            </div>
                            <div class="d-flex justify-content-between">
                                
                                <p class="mb-2 text-muted">İlan Kodu :<span style="color: black"><?php echo e($post->code); ?></span></p>
                                <p class="mb-2 text-muted">İhale Kodu :<span style="color: black"><?php echo e($post->tender_code); ?></span></p>
                                
                            </div>
                            <div>
                                <h3 class="h6 text-success mb-3"><?php echo e($post->title); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script>
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/index.blade.php ENDPATH**/ ?>