<?php $__env->startSection('title', 'İlan Detayları'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
    <link href='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.css' rel='stylesheet' />
    <style>
        .card{
            border: 1px solid #e0e0e0;
            border-radius: 0px;
            padding: 25px;
            box-shadow: 0 0 5px rgb(0 0 0 / 10%);
            height: 100%;
        }
        .tender-detail-p{
            font-weight: 600;
            text-decoration: underline;
        }
        .tender-detail-p2{
            margin-left: 5px;
            overflow: hidden;
        }
        .mapboxgl-ctrl-bottom-left{
            display: none !important;
        }
        .mapboxgl-ctrl-bottom-right{
            display: none !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.properties.index')); ?>">Tüm İlanlar</a></li>
        <li class="breadcrumb-item"><a href="#">Ön İzleme</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e($post->title); ?></li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <?php echo $__env->make('flash_message.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <header class="border-bottom mt-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-list-alt"></i> İlan Detayları</h3>
    </header>
    
    
    <div class="py-3">
        <div class="">
            <div class="row">

                
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Temel Detaylar</h5>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Kodu:</p>
                            <p class="tender-detail-p2"><?php echo e($post->code); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka: </p>
                            <p class="tender-detail-p2"><?php echo e($post->bank->name); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka Teminat Oranı: </p>
                            <p class="tender-detail-p2">%<?php echo e($post->bank->deposit); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Emlak Tipi: </p>
                            <p class="tender-detail-p2">
                                <?php echo e(config('enums.property_type')[$property->property_type]); ?>

                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Başlığı: </p>
                            <p class="tender-detail-p2"><?php echo e($post->title); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Açıklaması: </p>
                            <p class="tender-detail-p2">
                                <?php echo $post->desc; ?>

                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Fırsat Butonu:</p>
                            <p class="tender-detail-p2">
                                <?php if($post->is_opportunity == 0): ?>
                                    <i class="fa fa-times" aria-hidden="true" style="color:red;"></i>
                                <?php elseif($post->is_opportunity == 1): ?>
                                    <i class="fa fa-check" aria-hidden="true" style="color:green;"></i>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlan Süresi: </p>
                            <p class="tender-detail-p2"><?php echo e($postDay); ?> Gün <?php echo e($postHour); ?> Saat</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Başlangıç Bedeli: </p>
                            <p class="tender-detail-p2">
                                <?php echo e(number_format($post->start_price, 0, '.', '.')); ?>&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Teklif Adımı: </p>
                            <p class="tender-detail-p2">
                                <?php echo e(number_format($post->offer_step, 0, '.', '.')); ?>&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Teminatı Markest Tutacak?: </p>
                            <p class="tender-detail-p2">
                                <?php if($property->post->is_warrant == 0): ?>
                                    Hayır
                                <?php elseif($property->post->is_warrant == 1): ?>
                                    Evet
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Banka İhale Teminat Bedeli: </p>
                            <p class="tender-detail-p2">
                                <?php echo e(number_format($post->entry_price, 0, '.', '.')); ?>&#x20BA;
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Markest İhale Katılım Bedeli: </p>
                            <p class="tender-detail-p2"><?php echo e(number_format($post->deposit_ratio, 0, '.', '.')); ?>&#x20BA;</p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Hemen Al Açık?: </p>
                            <p class="tender-detail-p2">
                                <?php if($property->post->is_fast_buy == 0): ?>
                                    Hayır
                                <?php elseif($property->post->is_fast_buy == 1): ?>
                                    Evet
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Hemen Al Fiyatı: </p>
                            <p class="tender-detail-p2">
                                <?php echo e(number_format($post->fast_buy_price, 0, '.', '.')); ?>&#x20BA;
                            </p>
                        </div>
                        
                    </div>
                </div>

                
                <?php if($property->property_type == 0): ?>
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Konut Tipi:</p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->house_type)): ?>
                                    <?php echo e(config('enums.house_type')[$property->house_type]); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Brüt m2: </p>
                                <p class="tender-detail-p2"><?php echo e(number_format($property->gross_m2, 0, '.', '.')); ?>m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2"><?php echo e(number_format($property->net_m2, 0, '.', '.')); ?>m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bina Yaşı: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->building_age)): ?>
                                    <?php echo e(config('enums.building_age')[$property->building_age]); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Isıtma: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->heating_type)): ?>
                                    <?php echo e(config('enums.heating_type')[$property->heating_type]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kullanım Durumu: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->using_status)): ?>
                                    <?php echo e(config('enums.using_status')[$property->using_status]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Oda Sayısı:</p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->room_count)): ?>
                                    <?php echo e(config('enums.room_count')[$property->room_count]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bulunduğu Kat: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->floor)): ?>
                                    <?php echo e(config('enums.floor')[$property->floor]); ?>.Kat
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kat Sayısı: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->total_floor)): ?>
                                    <?php echo e(config('enums.total_floor')[$property->total_floor]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Banyo Sayısı: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->bath_count)): ?>
                                    <?php echo e(config('enums.bath_count')[$property->bath_count]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Balkon: </p>
                                <p class="tender-detail-p2">
                                    <?php if($property->is_balcony == 1): ?>
                                        Var
                                    <?php else: ?>
                                        Yok
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Eşyalı: </p>
                                <p class="tender-detail-p2">
                                    <?php if($property->is_furnished == 1): ?>
                                        Evet
                                    <?php else: ?>
                                        Hayır
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Site İçerisinde: </p>
                                <p class="tender-detail-p2">
                                    <?php if($property->is_site == 1): ?>
                                        Evet
                                    <?php else: ?>
                                        Hayır
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kredi Uygun: </p>
                                <p class="tender-detail-p2">
                                    <?php if($property->is_creditable == 1): ?>
                                        Evet
                                    <?php else: ?>
                                        Hayır
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Aidat: </p>
                                <p class="tender-detail-p2"><?php echo e($property->dues); ?></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Cephe: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->side)): ?>
                                        <?php $__currentLoopData = unserialize($property->side); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $side): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.side')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">İç Özellikler: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->inside_properties)): ?>
                                        <?php $__currentLoopData = unserialize($property->inside_properties); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $inside_properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.inside_properties')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Dış Özellikler: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->outside_properties)): ?>
                                        <?php $__currentLoopData = unserialize($property->outside_properties); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $outside_properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.outside_properties')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if($property->property_type == 1): ?>
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">İş Yeri Tipi:</p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->workplace_type)): ?>
                                    <?php echo e(config('enums.workplace_type')[$property->workplace_type]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Brüt m2: </p>
                                <p class="tender-detail-p2"><?php echo e(number_format($property->gross_m2, 0, '.', '.')); ?>m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2"><?php echo e(number_format($property->net_m2, 0, '.', '.')); ?>m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Bina Yaşı: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->building_age)): ?>
                                    <?php echo e(config('enums.building_age')[$property->building_age]); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Isıtma: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->heating_type)): ?>
                                    <?php echo e(config('enums.heating_type')[$property->heating_type]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kullanım Durumu: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->using_status)): ?>
                                    <?php echo e(config('enums.using_status')[$property->using_status]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Aidat: </p>
                                <p class="tender-detail-p2"><?php echo e($property->dues); ?></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Cephe: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->side)): ?>
                                        <?php $__currentLoopData = unserialize($property->side); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $side): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.side')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Genel Özellikler: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->general_properties)): ?>
                                        <?php $__currentLoopData = unserialize($property->general_properties); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $general_properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.general_properties')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if($property->property_type == 2): ?>
                    <div class="col-6 mb-4">
                        <div class="card">
                            <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">İlan Detayları</h5>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Arsa Tipi:</p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->land_type)): ?>
                                    <?php echo e(config('enums.land_type')[$property->land_type]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Net m2: </p>
                                <p class="tender-detail-p2"><?php echo e(number_format($property->net_m2, 0, '.', '.')); ?>m<sup>2</sup></p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Kaks(Emsal): </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->peer)): ?>
                                    <?php echo e(config('enums.peer')[$property->peer]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Gabari: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->clearence)): ?>
                                    <?php echo e(config('enums.clearence')[$property->clearence]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Tapu Durumu: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->land_state)): ?>
                                    <?php echo e(config('enums.land_state')[$property->land_state]); ?>

                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Altyapı: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->infrastructure)): ?>
                                        <?php $__currentLoopData = unserialize($property->infrastructure); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $infrastructure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.infrastructure')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                            <div class="form-row m-0">
                                <p class="tender-detail-p">Genel Özellikler: </p>
                                <p class="tender-detail-p2">
                                    <?php if(isset($property->general_properties_land)): ?>
                                        <?php $__currentLoopData = unserialize($property->general_properties_land); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $general_properties_land): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span><?php echo e(config('enums.general_properties_land')[$key]); ?></span>,
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Adres</h5>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İl:</p>
                            <p class="tender-detail-p2"><?php echo e($property->country); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">İlçe: </p>
                            <p class="tender-detail-p2"><?php echo e($property->district); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Semt/Mahalle: </p>
                            <p class="tender-detail-p2"><?php echo e($property->neighborhood); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Adres: </p>
                            <p class="tender-detail-p2"><?php echo e($property->address); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Ada No: </p>
                            <p class="tender-detail-p2"><?php echo e($property->city_block_no); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Parsel No: </p>
                            <p class="tender-detail-p2"><?php echo e($property->parcel_no); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Kat No: </p>
                            <p class="tender-detail-p2"><?php echo e($property->floor_no); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Blok No: </p>
                            <p class="tender-detail-p2"><?php echo e($property->block_no); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">BB No: </p>
                            <p class="tender-detail-p2"><?php echo e($property->independent_section_no); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Parsel Sorgu Url: </p>
                            <p class="tender-detail-p2"><?php echo e($property->parsel_request_url); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Enlem: </p>
                            <p class="tender-detail-p2"><?php echo e($property->langitude); ?></p>
                        </div>
                        <div class="form-row m-0">
                            <p class="tender-detail-p">Boylam: </p>
                            <p class="tender-detail-p2"><?php echo e($property->longitude); ?></p>
                        </div>
                    </div>
                </div>

                
                <div class="col-6 mb-4">
                    <div class="card">
                        <h5 class="text-center" style="text-decoration: underline;color: forestgreen;">Resimler</h5>
                        <div class="form-row m-0">
                            <?php $__currentLoopData = Storage::allFiles($property->post->images_folder); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-4 mb-2">
                                    <img class="img-fluid" style="height: 150px;object-fit: cover;width: 100%;" src="<?php echo e(Storage::url($image)); ?>">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="card">
                        <div id="map" style="width: 100%; height: 500px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script src='https://api.mapbox.com/mapbox-gl-js/v2.3.1/mapbox-gl.js'></script>
    <script>
        $(function () {
            var lantg = <?php echo $property->longitude; ?>;
            var lontg = <?php echo $property->langitude; ?>;
        
            mapboxgl.accessToken = 'pk.eyJ1IjoicHJvcHR1cmsiLCJhIjoiY2t6cDk0MWZtMDhtNTJvbzJ1MWtpYTdyeiJ9._g9p7Eb8o8IaUMLKnHyRag';
            const map = new mapboxgl.Map({
                container: 'map', // container ID
                style: 'mapbox://styles/mapbox/streets-v11', // style URL
                center: [lantg, lontg], // starting position [lng, lat]
                zoom: 15 // starting zoom
            });
            const marker = new mapboxgl.Marker()
            .setLngLat([lantg, lontg])
            .addTo(map);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/properties/show.blade.php ENDPATH**/ ?>