<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="color-scheme" content="light">
    <meta name="supported-color-schemes" content="light">
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        h1{
            font-size: 16px;
        }
        h2{
            font-size: 14px;
        }
        p{
            font-size: 12px;
        }
        .head-p1{
            font-size: 28px;
            color: cadetblue;
        }
        .head-p2{
            font-size: 26px;
            color: cadetblue;
        }
        .head-p3{
            font-size: 24px;
            color: black;
        }
        .max-table{
            max-width: 2480px;
            width:100%;
        }
        .max-table td{
            width: auto;
            overflow: hidden;
            word-wrap: break-word;
        }

    </style>
</head>
<body>
    <div align="center" style="border:2px solid cadetblue;">
        <br/>
        <p class="head-p1">
            <strong><?php echo e($post_code); ?>.</strong>
        </p>
        <p class="head-p2">
            <strong><?php echo e($post_title); ?></strong>
        </p>
        <p class="head-p3">
            <strong><?php echo e($post_start_date); ?> - <?php echo e($post_end_date); ?></strong>
        </p>
        <br/>
        <br/>
        <br/>
        <img
            src="<?php echo e($post_image); ?>"
            width="461"
            height="346"
        />
        <br/>
        <br/>
        <p>
           <strong><?php echo e($city); ?>, <?php echo e($district); ?></strong>
        </p>
        <br/>
        <br/>
        <br/>
        <br/>
        <img
            src="<?php echo e($bank_logo); ?>"
            width="195"
            height="84"
        />
        <br/>
    </div>
    <br/>

    <div style="float:none;break-after:page"></div>
    <h1 dir="ltr">
        <?php echo e($post_code); ?> Emlak Kodlu Gayrımenkule Ait Bilgiler
    </h1>
    <p dir="ltr">
        Şehir: <?php echo e($city); ?>

    </p>
    <p dir="ltr">
        İlçe: <?php echo e($district); ?>

    </p>
    <p dir="ltr">
        Mahalle: <?php echo e($neighborhood); ?>

    </p>
    <p dir="ltr">
        Ada No: <?php echo e($city_block_no); ?>

    </p>
    <p dir="ltr">
        Parsel No: <?php echo e($parcel_no); ?>

    </p>
    <p dir="ltr">
        Kat No: <?php echo e($floor_no); ?>

    </p>
    <p dir="ltr">
        Blok No: <?php echo e($block_no); ?>

    </p>
    <p dir="ltr">
        Bağımsız Bölüm No: <?php echo e($independent_section_no); ?>

    </p>
    <p dir="ltr">
        Adres: <?php echo e($address); ?>

    </p>
    <p dir="ltr">
        İlana Çıkış <?php echo e($post_start_date_formatted); ?>

    </p>
    <br/>
    <div style="break-after:page"></div>
    <h1 dir="ltr">
        İhale Tarihçesi
    </h1>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="5">
            
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            Başlangıç
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Bitiş
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Başlangıç Bedeli
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Min. Artış
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            İstekli Sayısı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Teklif Sayısı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En İyi Teklif
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            İzlenme Sayısı
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <p dir="ltr">
                            <?php echo e($post_start_date_formatted); ?>

                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($post_end_date_formatted); ?>

                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($start_price); ?>₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($offer_step); ?>₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($post_user_count); ?>

                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($post_offer_count); ?>

                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e(number_format($best_price, 0, '.', '.')); ?>₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($post_view_count); ?>

                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <p dir="ltr">
        Katılımcılar ve Tekliflerine Ait Bilgiler
    </p>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="5">
            
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            İstekli Adı
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            T.C. Kimlik No
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Cep Tel
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            E-posta
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Kaydı alan Şube
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En Yüksek Teklifi
                        </p>
                    </td>
                </tr>
                <?php $__currentLoopData = $post_with_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <p dir="ltr">
                                <?php echo e($item->user->name); ?> <?php echo e($item->user->surname); ?>

                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                <?php echo e($item->user->identity_number); ?>

                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                <?php echo e($item->user->phone_number); ?>

                            </p>
                        </td>
                        <td>
                            <p dir="ltr">
                                <a href="mailto:<?php echo e($item->user->email); ?>">
                                    <?php echo e($item->user->email); ?>

                                </a>
                            </p>
                        </td>
                        <td>
                            <br/>
                        </td>
                        <td>
                            <p dir="ltr">
                                <?php echo e(number_format($item->price, 0, '.', '.'),); ?>₺
                            </p>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <br/>
    <br/>
    <br/>
    <br/>
    <br/>
    <div style="break-after:page"></div>
    <h1 dir="ltr">
        Teklif Listesi
    </h1>
    <?php $__currentLoopData = $post_with_user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p dir="ltr">
            <?php echo e($key); ?> - <?php echo e($item->user->name); ?> <?php echo e($item->user->surname); ?> - <?php echo e(number_format($item->price, 0, '.', '.'),); ?>₺ / <?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d.m.Y H:i')); ?>

        </p>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <br/>
    <br/>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="15">
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            Başlangıç Bedeli
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            En İyi Teklif
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Yüzde Artış
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Artış Miktarı
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <p dir="ltr">
                            <?php echo e($start_price); ?>₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e(number_format($best_price, 0, '.', '.')); ?>₺
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            % <?php echo e($offerPercentageRise); ?>

                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            <?php echo e($offer_step); ?>₺
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <h1 dir="ltr">
        Tapu Bilgileri
        <br/>
    </h1>
    <p dir="ltr">
        Taşınmazın tapu devri, ihaleyi kazanan isteklinin talebi doğrultusunda
        aşağıda belirtilen kişiler ve hisse oranları çerçevesinde yapılacaktır:
    </p>
    <div dir="ltr" align="left">
        <table class="max-table" border="1" cellspacing="0" cellpadding="0">
            <tbody>
                <tr>
                    <td>
                        <p dir="ltr">
                            T.C. Kimlik No
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Ad
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Soyad
                        </p>
                    </td>
                    <td>
                        <p dir="ltr">
                            Pay
                        </p>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <p dir="ltr">
                            Toplam
                        </p>
                    </td>
                    <td>
                        <br/>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <br/>
    <h1 dir="ltr">
        Sonuç
    </h1>
    <p dir="ltr">
        <?php echo e($post_code); ?>. nolu <?php echo e($post_title); ?> isimli gayrimenkulün satış
        ihalesi <?php echo e($post_start_date); ?> - <?php echo e($post_end_date); ?> tarihleri arasında gerçekleştirilmiş olup, ihaleyi
        <?php echo e(number_format($best_price, 0, '.', '.')); ?>₺ ile en yüksek teklif veren <?php echo e($winner->name); ?> <?php echo e($winner->surname); ?> kazanmıştır.
    </p>
    <div>
        <br/>
    </div>
</body>
</html><?php /**PATH /var/www/html/propturk/resources/views/mail/pdf-templates/finished-tender-report.blade.php ENDPATH**/ ?>