<?php $__env->startSection('title', 'Kullanıcı Düzenle'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('styles'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb bg-transparent p-0 text_small">
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Admin</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users.index')); ?>">Kullanıcılar</a></li>
        <li class="breadcrumb-item active">Mail Gönder</li>
    </ol>
</nav>

<section class="mb-5 pb-5">
    <header class="border-bottom my-4">
        <h3 class="text-primary font-weight-light"><i class="far fa-id-badge"></i> Mail Gönder</h3>
        <h4 style="margin-top: 25px;"><?php echo e($user->name); ?> <?php echo e($user->surname); ?></h4>
    </header>

    <div class="row py-3">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="tab-content" id="pills-tabContent">
                <section class="tab-pane fade show active" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <div class="py-3">
                        <form class="auto_save text-muted" action="<?php echo e(route('admin.users.sendCustomMailUser', ['user' => $user->id])); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('POST'); ?>
                            <div class="form-row">
                                <div class="col-sm-6 col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label for="post">İhale Seçiniz</label>
                                        <select class="form-control" name="post" id="select-post">
                                                    <option value="0">İhale Seçiniz</option>
                                                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($post->id); ?>"><?php echo e($post->code); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12 pl-0">
                                            <label for="deposit_ratio">İhaleye Dahil Edilecek Evraklar:</label>
                                            <div id="contact-container">    </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="text-right pt-4">
                                <button type="submit" class="btn btn-lg btn-danger slow_3s  position-relative px-5">Mail Gönder
                                    <span class="form_load position-absolute">
                                        <span class="spinner-border text-light" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </span>
                                    </span>
                                </button>
                            </div>
                        </form>

                        <?php if($errors->any()): ?>
                            <div class="mt-2 mb-2">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="alert alert-danger" role="alert">
                                        <?php echo e($error); ?>

                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                        
                    </div>
                </section>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo \Illuminate\View\Factory::parentPlaceholder('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/l7eedze67bnr8a9hl4z2bx1b88njp4q0czpsnfkdmyrwkjyg/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#select-post').change(function() {
                var postId = $('#select-post').val();

                $.ajax({
                    type:'GET',
                    url: "<?php echo route('admin.users.getBankContract', ''); ?>" + "/" + postId,
                    success:function(data){
                        $('#contact-container').empty();
                        
                        $.each(data.contracts, function (indexInArray, contract) { 
                            $("#contact-container").append(
                                '<div class="col-auto">'+
                                    '<input class="contracts" id=contract_'+contract.id+' type="checkbox"'+
                                    'value="'+contract.id+'" name="contracts[]">'+
                                    '<span style="margin-right: 15px;">'+contract.contract_name+'</span>'+
                                '</div>'
                            );
                            if(contract.is_checked == 1) {
                                $('#contract_'+contract.id).prop('checked', true);
                            }                            
                        });
                    }
                });
            });            
        });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/propturk/resources/views/admin/users/send-custom-mail.blade.php ENDPATH**/ ?>